% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{flush_decompressor_buffer}
\alias{flush_decompressor_buffer}
\title{Flush the internal buffer of the decompressor object.}
\usage{
flush_decompressor_buffer(decompressorPtr, length = 256L)
}
\arguments{
\item{decompressorPtr}{A SEXP pointer to an existing decompressor object.}

\item{length}{An optional parameter that sets the initial size of the output buffer. Default is 256.}
}
\value{
A raw vector containing the remaining uncompressed output.
}
\description{
This function processes all pending input and returns the remaining uncompressed output.
The function uses the provided initial buffer size and dynamically expands it as necessary
to ensure all remaining data is decompressed. After calling this function, the
decompress_chunk() method cannot be called again on the same object.
}
\examples{
decompressor <- create_decompressor()
# ... (some decompression actions)
flushed_data <- flush_decompressor_buffer(decompressor)
}
