% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{zlib_constants}
\alias{zlib_constants}
\title{Retrieve zlib Constants}
\usage{
zlib_constants()
}
\value{
A named list of zlib constants.
}
\description{
This function returns a list of constants from the zlib C library.
}
\details{
The constants are defined as follows:
\itemize{
\item \code{DEFLATED}: The compression method, set to 8.
\item \code{DEF_BUF_SIZE}: The default buffer size, set to 16384.
\item \code{DEF_MEM_LEVEL}: Default memory level, set to 8.
\item \code{MAX_WBITS}: Maximum size of the history buffer, set to 15.
\item \code{Z_BEST_COMPRESSION}: Best compression level, set to 9.
\item \code{Z_BEST_SPEED}: Best speed for compression, set to 1.
\item \code{Z_BLOCK}: Block compression mode, set to 5.
\item \code{Z_DEFAULT_COMPRESSION}: Default compression level, set to -1.
\item \code{Z_DEFAULT_STRATEGY}: Default compression strategy, set to 0.
\item \code{Z_FILTERED}: Filtered compression mode, set to 1.
\item \code{Z_FINISH}: Finish compression mode, set to 4.
\item \code{Z_FULL_FLUSH}: Full flush mode, set to 3.
\item \code{Z_HUFFMAN_ONLY}: Huffman-only compression mode, set to 2.
\item \code{Z_NO_COMPRESSION}: No compression, set to 0.
\item \code{Z_NO_FLUSH}: No flush mode, set to 0.
\item \code{Z_PARTIAL_FLUSH}: Partial flush mode, set to 1.
\item \code{Z_RLE}: Run-length encoding compression mode, set to 3.
\item \code{Z_SYNC_FLUSH}: Synchronized flush mode, set to 2.
\item \code{Z_TREES}: Tree block compression mode, set to 6.
}
}
\examples{
constants <- zlib_constants()
}
\keyword{internal}
