% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.mexhazLT.R
\name{anova.mexhazLT}
\alias{anova.mexhazLT}
\title{anova.mexhazLT function used for likelihood-ratio Test of two models
from mexhaz function}
\usage{
\method{anova}{mexhazLT}(object, ..., test = "LRT")
}
\arguments{
\item{object}{an object of class mexhazLT}

\item{...}{an object of class mexhazLT}

\item{test}{a character string. The appropriate test is a likelihood-ratio
test, all other choices result in Not yet implemented test.}
}
\value{
An object of class \code{anova} inheriting from class \code{matrix}.
The different columns contain respectively the degrees of freedom and the
log-likelihood values of the two nested models, the degree of freedom of the
chi-square statistic, the chi-square statistic and the p-value of the
likelihood ratio test.
}
\description{
This function compute an analysis of deviance table for two
excess hazard models fitted using xhaz R package.
}
\note{
As expected, the comparison between two or more models by anova or more
excess hazard models will only be valid if they are fitted to the same
dataset, and if the compared models are nested. This may be a problem if
there are missing values.
}
\examples{
\donttest{
# load the data set in the package
library("survival")
library("numDeriv")
library("survexp.fr")


breast$sexe <- "female"

fit.haz <- exphaz(
                  formula = Surv(temps, statut) ~ 1,
                  data = breast, ratetable = survexp.us,
                  only_ehazard = FALSE,
                  rmap = list(age = 'age', sex = 'sexe', year = 'date'))

breast$expected <- fit.haz$ehazard
breast$expectedCum <- fit.haz$ehazardInt

mod.bs3 <- mexhazLT(formula = Surv(temps, statut) ~ agecr + armt,
                  data = breast,
                  ratetable = survexp.us, degree = 3,
                  knots=quantile(breast[breast$statut==1,]$temps, probs=c(1:2/3)),
                  expected = "expected",expectedCum = "expectedCum",
                  base = "exp.bs", pophaz = "classic", random ="hosp")

mod.bs3

mod.bs4 <- mexhazLT(formula = Surv(temps, statut) ~ agecr + armt,
                  data = breast,
                  ratetable = survexp.us, degree = 3,
                  knots=quantile(breast[breast$statut==1,]$temps, probs=c(1:2/3)),
                  expected = "expected",expectedCum = "expectedCum",
                  base = "exp.bs", pophaz = "rescaled", random = "hosp")

mod.bs4

  anova(mod.bs3, mod.bs4)
}

}
\references{
Goungounga JA, Touraine C, Graff\'eo N, Giorgi R;
CENSUR working survival group. Correcting for misclassification
and selection effects in estimating net survival in clinical trials.
BMC Med Res Methodol. 2019 May 16;19(1):104.
doi: 10.1186/s12874-019-0747-3. PMID: 31096911; PMCID: PMC6524224.
(\href{https://pubmed.ncbi.nlm.nih.gov/31096911/}{PubMed})

Goungounga, JA, Graff\'eo N, Charvat H, Giorgi R. “Correcting for
heterogeneity and non-comparability bias in multicenter clinical trials
with a rescaled random-effect excess hazard model.” Biometrical journal.
Biometrische Zeitschrift vol. 65,4 (2023): e2100210.
doi:10.1002/bimj.202100210.PMID: 36890623;
(\href{https://pubmed.ncbi.nlm.nih.gov/36890623/}{PubMed})
}
\seealso{
\code{\link{xhaz}}, \code{\link{mexhazLT}}, \code{\link{AIC.mexhazLT}}
}
\author{
Juste Goungounga, Hadrien Charvat, Robert Darlin Mba, Nathalie Graff\'eo and Roch Giorgi
}
\keyword{anova.mexhazLT}
