% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNFfileIO.R
\name{readBNF}
\alias{readBNF}
\title{Read text file.}
\usage{
readBNF(filename, eol = "")
}
\arguments{
\item{filename}{A file name.}

\item{eol}{End-of-line symbol(s). Default: ""}
}
\value{
A named list with
    \itemize{
        \item $filename  the filename.
        \item $BNF a character string with the newline symbol \\n.
        }
}
\description{
\code{readBNF()} reads a text file and 
             returns a character string.
}
\examples{
g<-booleanGrammar()
fn<-tempfile()
writeBNF(g, fn)
g1<-readBNF(fn)
unlink(fn)
}
\seealso{
Other File I/O: 
\code{\link{newBNF}()},
\code{\link{writeBNF}()}
}
\concept{File I/O}
