% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.R
\name{name}
\alias{name}
\title{Generate Random Vector of Names}
\usage{
name(
  n,
  x = wakefield::name_neutral,
  prob = NULL,
  replace = FALSE,
  name = "Name"
)
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{replace}{logical.  If \code{TRUE} sampling is done with replacement.
Default is without replacement.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of name elements.
}
\description{
Generate a random vector of first names. This dataset includes all unique entries
from the \code{babynames} package.
}
\examples{
name(10)
name(100)
name(1000, replace = TRUE)
}
\seealso{
Other variable functions: 
\code{\link{age}()},
\code{\link{animal}()},
\code{\link{answer}()},
\code{\link{area}()},
\code{\link{car}()},
\code{\link{children}()},
\code{\link{coin}()},
\code{\link{color}},
\code{\link{date_stamp}()},
\code{\link{death}()},
\code{\link{dice}()},
\code{\link{dna}()},
\code{\link{dob}()},
\code{\link{dummy}()},
\code{\link{education}()},
\code{\link{employment}()},
\code{\link{eye}()},
\code{\link{grade_level}()},
\code{\link{grade}()},
\code{\link{group}()},
\code{\link{hair}()},
\code{\link{height}()},
\code{\link{income}()},
\code{\link{internet_browser}()},
\code{\link{iq}()},
\code{\link{language}},
\code{\link{level}()},
\code{\link{likert}()},
\code{\link{lorem_ipsum}()},
\code{\link{marital}()},
\code{\link{military}()},
\code{\link{month}()},
\code{\link{normal}()},
\code{\link{political}()},
\code{\link{race}()},
\code{\link{religion}()},
\code{\link{sat}()},
\code{\link{sentence}()},
\code{\link{sex_inclusive}()},
\code{\link{sex}()},
\code{\link{smokes}()},
\code{\link{speed}()},
\code{\link{state}()},
\code{\link{string}()},
\code{\link{upper}()},
\code{\link{valid}()},
\code{\link{year}()},
\code{\link{zip_code}()}
}
\concept{variable functions}
\keyword{name}
