% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upper.R
\name{upper}
\alias{upper}
\alias{lower}
\alias{upper_factor}
\alias{lower_factor}
\title{Generate Random Letter Vector}
\usage{
upper(n, k = 5, x = LETTERS, prob = NULL, name = "Upper")

lower(
  n,
  k = 5,
  x = c("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p",
    "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"),
  prob = NULL,
  name = "Lower"
)

upper_factor(n, k = 5, x = LETTERS, prob = NULL, name = "Upper")

lower_factor(
  n,
  k = 5,
  x = c("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p",
    "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"),
  prob = NULL,
  name = "Lower"
)
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{k}{The number of the elements of x to sample from (uses 1:k).}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random character/factor vector of letter elements.
}
\description{
\code{upper} - Generates a random character vector of upper case letters.

\code{lower} - Generates a random character vector of lower case letters.

\code{upper_factor} - Generates a random factor vector of upper case letters.

\code{lower_factor} - Generates a random factor vector of lower case letters.
}
\examples{
upper(10)
lower(10)
upper_factor(10)
lower_factor(10)
barplot(table(upper(10000)))
barplot(table(upper(10000, prob = probs(5))))
}
\seealso{
Other variable functions: 
\code{\link{age}()},
\code{\link{animal}()},
\code{\link{answer}()},
\code{\link{area}()},
\code{\link{car}()},
\code{\link{children}()},
\code{\link{coin}()},
\code{\link{color}},
\code{\link{date_stamp}()},
\code{\link{death}()},
\code{\link{dice}()},
\code{\link{dna}()},
\code{\link{dob}()},
\code{\link{dummy}()},
\code{\link{education}()},
\code{\link{employment}()},
\code{\link{eye}()},
\code{\link{grade_level}()},
\code{\link{grade}()},
\code{\link{group}()},
\code{\link{hair}()},
\code{\link{height}()},
\code{\link{income}()},
\code{\link{internet_browser}()},
\code{\link{iq}()},
\code{\link{language}},
\code{\link{level}()},
\code{\link{likert}()},
\code{\link{lorem_ipsum}()},
\code{\link{marital}()},
\code{\link{military}()},
\code{\link{month}()},
\code{\link{name}},
\code{\link{normal}()},
\code{\link{political}()},
\code{\link{race}()},
\code{\link{religion}()},
\code{\link{sat}()},
\code{\link{sentence}()},
\code{\link{sex_inclusive}()},
\code{\link{sex}()},
\code{\link{smokes}()},
\code{\link{speed}()},
\code{\link{state}()},
\code{\link{string}()},
\code{\link{valid}()},
\code{\link{year}()},
\code{\link{zip_code}()}
}
\concept{variable functions}
\keyword{capitals}
\keyword{letters}
\keyword{lower}
\keyword{upper}
