# R package `vismeteor`

## About The Project

This R package provides tools for the analysis of visual meteor observations from the Visual Meteor Database (VMDB) of the [International Meteor Organization](https://www.imo.net/).

The data used in this package are provided by [imo-vmdb](https://pypi.org/project/imo-vmdb/). But it is also possible to perform analyses without using this data.

## Installation

Install the released version from CRAN:

```r
install.packages("vismeteor")
```

## Getting Started

Explore the vignettes for full workflows and methodology:

- `vignette("vismeteor")` – package overview and concepts
- `vignette("vmgeom")` – parameter estimation for the geometric model
- `vignette("vmideal")` – parameter estimation for the ideal distribution

## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.

If you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".

1.  Fork the Project
2.  Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3.  Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4.  Push to the Branch (`git push origin feature/AmazingFeature`)
5.  Open a Pull Request

## License

Distributed under the MIT License. See `LICENSE` for more information.

## Contact

Janko Richter - [janko\@richtej.de](mailto:janko@richtej.de)

Project Link: <https://github.com/jankorichter/vismeteor>
