% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{vec_expand_grid}
\alias{vec_expand_grid}
\title{Create a data frame from all combinations of the inputs}
\usage{
vec_expand_grid(
  ...,
  .vary = "slowest",
  .name_repair = "check_unique",
  .error_call = current_env()
)
}
\arguments{
\item{...}{Name-value pairs. The name will become the column name in the
resulting data frame.}

\item{.vary}{One of:
\itemize{
\item \code{"slowest"} to vary the first column slowest. This produces sorted
output and is generally the most useful.
\item \code{"fastest"} to vary the first column fastest. This matches the behavior
of \code{\link[=expand.grid]{expand.grid()}}.
}}

\item{.name_repair}{One of \code{"check_unique"}, \code{"unique"}, \code{"universal"},
\code{"minimal"}, \code{"unique_quiet"}, or \code{"universal_quiet"}. See \code{\link[=vec_as_names]{vec_as_names()}}
for the meaning of these options.}

\item{.error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A data frame with as many columns as there are inputs in \code{...} and as many
rows as the \code{\link[=prod]{prod()}} of the sizes of the inputs.
}
\description{
\code{vec_expand_grid()} creates a new data frame by creating a grid of all
possible combinations of the input vectors. It is inspired by
\code{\link[=expand.grid]{expand.grid()}}. Compared with \code{expand.grid()}, it:
\itemize{
\item Produces sorted output by default by varying the first column the slowest,
rather than the fastest. Control this with \code{.vary}.
\item Never converts strings to factors.
\item Does not add additional attributes.
\item Drops \code{NULL} inputs.
\item Can expand any vector type, including data frames and \link[=new_rcrd]{records}.
}
}
\details{
If any input is empty (i.e. size 0), then the result will have 0 rows.

If no inputs are provided, the result is a 1 row data frame with 0 columns.
This is consistent with the fact that \code{prod()} with no inputs returns \code{1}.
}
\examples{
vec_expand_grid(x = 1:2, y = 1:3)

# Use `.vary` to match `expand.grid()`:
vec_expand_grid(x = 1:2, y = 1:3, .vary = "fastest")

# Can also expand data frames
vec_expand_grid(
  x = data_frame(a = 1:2, b = 3:4),
  y = 1:4
)
}
