% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_outbreak_prob}
\alias{plot_outbreak_prob}
\title{Plot Outbreak Probability vs. Coverage}
\usage{
plot_outbreak_prob(
  disease = "Measles",
  VE = NULL,
  r0_custom = NULL,
  save_data_to = NULL
)
}
\arguments{
\item{disease}{The disease to model. Default is "Measles".}

\item{VE}{Vaccine effectiveness. If NULL (the default), a sensible default is
used for the chosen disease (e.g., 0.97 for Measles). A user-provided
value (0 to 1) will override the default.}

\item{r0_custom}{The basic reproduction number (R0) for a custom disease.
Required only if `disease` is "Custom".}

\item{save_data_to}{Optional file path to save the plot's data.}
}
\value{
A ggplot object.
}
\description{
Plot Outbreak Probability vs. Coverage
}
\examples{
# Plot with default VE for Pertussis (~0.85)
plot_outbreak_prob(disease = "Pertussis")
# Override default VE for Pertussis
plot_outbreak_prob(disease = "Pertussis", VE = 0.91)
}
