% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{number_format}
\alias{number_format}
\title{Check the layouts of numbers.}
\usage{
number_format(x, format = NULL, min_dig = NULL, max_dig = NULL, dec = ".")
}
\arguments{
\item{x}{\code{[character]} vector. If \code{x} is not of type
\code{character} it will be converted.}

\item{format}{\code{[character]} denoting the number format (see below).}

\item{min_dig}{\code{[numeric]} minimal number of digits after decimal separator.}

\item{max_dig}{\code{[numeric]} maximum number of digits after decimal separator.}

\item{dec}{\code{[character]} decimal seperator.}
}
\description{
Convenience function to check layout of numbers stored as
a character vector.
}
\details{
If \code{format} is specified, then \code{min_dig}, \code{max_dig} and \code{dec}
are ignored.

Numerical formats can be specified as a sequence of characters. There are a few 
special characters:
\itemize{
 \item{\code{d}} Stands for digit.
 \item{\code{*}} (digit globbing) zero or more digits
}

Here are some examples.
\tabular{ll}{
\code{"d.dd"}   \tab One digit, a decimal point followed by two digits.\cr
\code{"d.ddddddddEdd"}\tab Scientific notation with eight digits behind the decimal point.\cr
\code{"0.ddddddddEdd"}\tab Same, but starting with a zero.\cr
\code{"d,dd*"} \tab one digit before the comma and at least two behind it.\cr
}
}
\examples{
df <- data.frame(number = c("12.34","0.23E55","0.98765E12"))
rules <- validator(
   number_format(number, format="dd.dd")
   , number_format(number, "0.ddEdd")
   , number_format(number, "0.*Edd")
)

out <- confront(df, rules)
values(out)

# a few examples, without 'validator'
number_format("12.345", min_dig=2) # TRUE
number_format("12.345", min_dig=4) # FALSE
number_format("12.345", max_dig=2) # FALSE
number_format("12.345", max_dig=5) # TRUE
number_format("12,345", min_dig=2, max_dig=3, dec=",") # TRUE

}
\seealso{
Other format-checkers: 
\code{\link{field_format}()},
\code{\link{field_length}()}
}
\concept{format-checkers}
