% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{hb}
\alias{hb}
\title{Hiridoglu-Berthelot function}
\usage{
hb(x, ref = stats::median, ...)
}
\arguments{
\item{x}{\code{[numeric]}}

\item{ref}{\code{[function]} or \code{[numeric]}}

\item{...}{arguments passed to \code{ref} after \code{x}}
}
\value{
\eqn{\max\{x/ref(x), ref(x)/x\}-1} if \code{ref} is a function,
        otherwise \eqn{\max\{x/ref, ref/x\}-1}
}
\description{
A function to measure `outlierness' for skew distributed data with long
right tails. The method works by measuring deviation from a reference
value, by default the median. Deviation from above is measured as the
ratio between observed and refence values. Deviation from below is
measured as the inverse: the ratio between reference value and 
observed values.
}
\examples{
x <- seq(1,20,by=0.1)
plot(x,hb(x), 'l')

}
\references{
Hidiroglou, M. A., & Berthelot, J. M. (1986). Statistical editing and
imputation for periodic business surveys. Survey methodology, 12(1), 73-83.
}
\seealso{
Other cross-record-helpers: 
\code{\link{contains_exactly}()},
\code{\link{do_by}()},
\code{\link{exists_any}()},
\code{\link{hierarchy}()},
\code{\link{is_complete}()},
\code{\link{is_linear_sequence}()},
\code{\link{is_unique}()}
}
\concept{cross-record-helpers}
