% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionset.R
\name{export_yaml}
\alias{export_yaml}
\alias{as_yaml}
\alias{export_yaml,expressionset-method}
\alias{as_yaml,expressionset-method}
\title{Export to yaml file}
\usage{
export_yaml(x, file, ...)

as_yaml(x, ...)

\S4method{export_yaml}{expressionset}(x, file, ...)

\S4method{as_yaml}{expressionset}(x, ...)
}
\arguments{
\item{x}{An R object}

\item{file}{A file location or connection (passed to \code{base::\link[base]{write}}).}

\item{...}{Options passed to \code{yaml::\link[yaml]{as.yaml}}}
}
\description{
Translate an object to yaml format and write to file.
}
\details{
Both \code{\link{validator}} and \code{\link{indicator}} objects can be
exported.
}
\examples{

v <- validator(x > 0, y > 0, x + y == z)
txt <- as_yaml(v)
cat(txt)


# NOTE: you can safely run the code below. It is enclosed in 'not run'
# statements to prevent the code from being run at test-time on CRAN
\dontrun{
export_yaml(v, file="my_rules.txt")
}

}
