% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickLabel.R
\name{pickLabel}
\alias{pickLabel}
\title{Pick the optimal label from candidate labels}
\usage{
pickLabel(
  n,
  text.predict = NULL,
  text.name = "text",
  top1.name = "top1",
  labels.index = NULL,
  candidate.labels = NULL
)
}
\arguments{
\item{n}{The number of desired tasks}

\item{text.predict}{A data frame or matrix containing both the text and the indicator(s)
of the model predicted topic(s).}

\item{text.name}{variable name in `text.predict` that indicates the text}

\item{top1.name}{variable name in `text.predict` that indicates the top1 model predicted topic}

\item{labels.index}{The topic index in correspondence with the labels, e.g., c(10, 12, 15).}

\item{candidate.labels}{A list of vectors containing the user-defined labels assigned to the topics,
Must be in the same length and order with `labels.index`.}
}
\value{
A matrix with n rows and 6 columns (topic, doc, opt1, opt2, opt3, optcrt) where optcrt is the correct label that was picked.
}
\description{
Pick the optimal label from candidate labels
}
\details{
Users need to specify four plausible labels for each topic
}
