% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HigherOrderRiskPreferences.R
\name{compute_measures}
\alias{compute_measures}
\title{Given a set of smooth and continuous functions, computes predefined and user-defined measures.}
\usage{
compute_measures(
  x_grids,
  coeffs,
  ids = NULL,
  ndx = 20,
  deg = 6,
  measures = c("risk-arrow-pratt", "crainich-eeckhoudt", "denuit-eeckhoudt"),
  ...
)
}
\arguments{
\item{x_grids}{a dataframe of vectors of x values for a smooth and continuous function.}

\item{coeffs}{a dataframe of coefficients for a smooth and continous function for each participant.}

\item{ids}{a list containing the IDs of the participants. If not given, a list with IDs from 1 to n_observations will be created.}

\item{ndx}{number of intervals to partition the distance between the lowest and highest x-values of the utility points.}

\item{deg}{degree of the B-spline basis. Determines the degree of the function to be estimated. If deg = 2, the estimated utility function will consist of quadratic functions.}

\item{measures}{a vector of measures to be computed.}

\item{...}{additional parameters for user-defined measures.}
}
\value{
A set of measurements.
}
\description{
Given a set of smooth and continuous functions, computes predefined and user-defined measures.
}
\examples{
x <- rbind(seq(0.000002, 1.0, (1.0 - 0.000002) / 1000),
           seq(0.001, 1.0, (1.0 - 0.001) / 1000),
           seq(0.0004, 1.0, (1.0 - 0.0004) / 1000))
y <- rbind(seq(0.000002, 1.0, (1.0 - 0.000002) / 15),
           seq(0.001, 1.0, (1.0 - 0.001) / 15),
           seq(0.0004, 1.0, (1.0 - 0.0004) / 15))
compute_measures(x, y, ndx = 10, deg = 6)
# x_finegrid, coeff, ndx, deg are always there to be used
# The function should have additional unknown arguments (...) if the given parameters are not used
risk_arrow_pratt <- function(x_finegrid, coeff, ndx, deg){ 
  dy_rd <- derivative(x_finegrid, coeff, 1, ndx, deg)
  ddy_rd <- derivative(x_finegrid, coeff, 2, ndx, deg)
  return (-mean(ddy_rd, na.rm = TRUE) / mean(dy_rd, na.rm = TRUE))
}
measures = c("crainich-eeckhoudt", "denuit-eeckhoudt", risk_arrow_pratt)
compute_measures(x, y, ndx = 10, deg = 6, measures=measures)
}
