% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action.R
\name{action}
\alias{action}
\title{Build and execute a \code{unifir_script}}
\usage{
action(script, write = TRUE, exec = TRUE, quit = TRUE)
}
\arguments{
\item{script}{The \code{unifir_script} object (as generated by \link{make_script})
to build and execute.}

\item{write}{Boolean: Write the generated script to a file?}

\item{exec}{Boolean: Execute the script inside of the Unity project? Note
that if \code{write = FALSE}, \code{exec} cannot be \code{TRUE}.}

\item{quit}{Boolean: Quit Unity after execution?}
}
\value{
If \code{exec = FALSE}, the original \code{unifir_script} object passed to
\code{script}. If \code{exec = TRUE}, the same \code{unifir_script} object with its
props replaced by the C# they generate.
}
\description{
Build and execute a \code{unifir_script}
}
\examples{
# First, create a script object.
# CRAN doesn't have Unity installed, so pass
# a waiver object to skip the Unity-lookup stage:
script <- make_script("example_script",
  unity = waiver()
)

# Then add any number of props to it:
script <- add_light(script)

# Then call `action` to execute the script!
\donttest{
if (interactive()) {
  action(script)
}
}

}
