% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyblom.R
\name{nyblom_test}
\alias{nyblom_test}
\title{Nyblom-Hansen Parameter Constancy Test}
\usage{
nyblom_test(
  x,
  scores = NULL,
  parameter_names = colnames(scores),
  parameter_symbols = NULL,
  ...
)
}
\arguments{
\item{x}{a series representing the standardized residuals of some estimated model.}

\item{scores}{the log likelihood score matrix. The \code{\link[sandwich]{estfun}} method
if exported by a package for a model will return this matrix.}

\item{parameter_names}{optional character vector of the parameter names. Usually
read off the column names of the score matrix.}

\item{parameter_symbols}{an optional character vector of the latex names of the
parameters which can be used when printing using the flextable format.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tstest.nyblom} which has a print and
as_flextable method.
}
\description{
The parameter constancy test of Nyblom (1989).
}
\details{
The p-values for the test statistic are based on a pre-computed density,
by simulation using equation 3.3 of Nyblom (1989), with up to 40 parameters and
saved as an internal data object within the package. A kernel density is used
to fit the 10,000 samples of the distribution before extracting the p-values.
The original simulation generated more than 100,000 data points but these
were compressed to quantiles at intervals of 0.001 in order to keep the package
size under 5MB.
}
\examples{
library(tsgarch)
library(xts)
data("spy")
spyr <- na.omit(diff(log(spy)))
spec <- garch_modelspec(spyr[1:1200], model = "garch", order = c(1,1),
constant = TRUE, distribution = "norm")
mod <- estimate(spec)
test <- nyblom_test(residuals(mod, standardize = TRUE), scores = estfun(mod),
parameter_names = names(coef(mod)),
parameter_symbols = mod$parmatrix[estimate == 1]$symbol)
print(test)

}
\references{
\insertRef{Nyblom1989}{tstests}
}
