% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tscor.cgarch.estimate}
\alias{tscor.cgarch.estimate}
\alias{tscor}
\alias{tscor.cgarch.simulate}
\alias{tscor.cgarch.predict}
\alias{tscor.dcc.estimate}
\alias{tscor.dcc.simulate}
\alias{tscor.dcc.predict}
\alias{tscor.gogarch.estimate}
\alias{tscor.gogarch.predict}
\alias{tscor.gogarch.simulate}
\title{Correlation Extractor}
\usage{
\method{tscor}{cgarch.estimate}(object, distribution = TRUE, ...)

\method{tscor}{cgarch.simulate}(object, distribution = TRUE, ...)

\method{tscor}{cgarch.predict}(object, distribution = TRUE, ...)

\method{tscor}{dcc.estimate}(object, distribution = TRUE, ...)

\method{tscor}{dcc.simulate}(object, distribution = TRUE, ...)

\method{tscor}{dcc.predict}(object, distribution = TRUE, ...)

\method{tscor}{gogarch.estimate}(object, distribution = TRUE, ...)

\method{tscor}{gogarch.predict}(object, distribution = TRUE, ...)

\method{tscor}{gogarch.simulate}(object, distribution = TRUE, ...)
}
\arguments{
\item{object}{an object class from one of the models in the package.}

\item{distribution}{whether to return the full simulated correlation distribution
for the predicted and simulated objects, else the average covariance across each
horizon.}

\item{...}{none}
}
\value{
the correlation (see details).
}
\description{
Extracts the conditional correlation matrices.
}
\details{
\subsection{Estimation Object}{

An array of correlation matrices with time as the third dimension.
The returned object has attributes \sQuote{index} representing the datetime
and \sQuote{series} representing the series names.
}

\subsection{Simulation and Prediction Objects}{

A 4-d array of dimensions (n_series x n_series x horizon x n_draws). If
\code{distribution} is FALSE, then the average covariance across all draws, an
array of dimensions (n_series x n_series x horizon).
}
}
\author{
Alexios Galanos
}
