% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsimilarity.R
\name{rsimilarity}
\alias{rsimilarity}
\title{Similarity of net rainfall time series}
\usage{
rsimilarity(Rn, FUN = "invKGE", parallel = FALSE, cores = NULL)
}
\arguments{
\item{Rn}{net rainfall matrix of gauged catchments (rows for time index, and columns for catchment index)}

\item{FUN}{either a function or a character string specifying the name of a predifined function to quantify the similarity of
two net rainfall time series. Higher values should indicate a higher probability of similarity. Predefined functions include:
"KGE" (Kling–Gupta efficiency), "invRMSE" (inverse of root mean square error), "invKGE" (inverse of (KGE-1))
and "RMSE" (root mean square error, should not be directly used as a similarity metric). The default is "invKGE"}

\item{parallel}{logical indicating whether the computation should be parallelised}

\item{cores}{the number of cores to use for parallel execution if \code{parallel} is TRUE.
If not specified, the number of cores is set to the value of \code{parallel::detectCores()}}
}
\value{
A square matrix of the similarity metric between each pair of catchments
}
\description{
Calculate the similarity of net rainfall time series
}
\examples{
\donttest{data(Oudon)
obs <- as_transfr(st = Oudon$obs, hl = Oudon$hl)
obs <- velocity(obs, method = "loire2016")
obs <- uh(obs)
obs <- lagtime(obs)
obs <- rapriori(obs)
obs <- inversion(obs, parallel = TRUE, cores=2)
msim <- rsimilarity(Rn = obs$st$RnInv, FUN="KGE", parallel = TRUE, cores=2)}
}
\seealso{
\link{rsimilarity_model}
}
