% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_repeat_correction_model}
\alias{plot_repeat_correction_model}
\title{Plot Repeat Correction Model}
\usage{
plot_repeat_correction_model(
  fragments_list,
  batch_run_id_subset = NULL,
  n_facet_col = 1
)
}
\arguments{
\item{fragments_list}{A list of fragments_repeats class objects obtained from the \code{\link[=call_repeats]{call_repeats()}} function when the \code{correction = "repeat"} parameter is used.}

\item{batch_run_id_subset}{A character vector for a subset of batch_sample_id to plot. Or alternatively supply a number to select batch sample by position in alphabetical order.}

\item{n_facet_col}{A numeric value indicating the number of columns for faceting in the plot.}
}
\value{
A base R graphic object displaying the repeat correction model results.
}
\description{
Plots the results of the repeat correction model for a list of fragments.
}
\details{
This function makes plots for the model used to correct samples for each \code{batch_run_id}. The repeat correction algorithm assigns the user supplied repeat length to the modal peak of the sample, then pulls out a set of robust neighboring peaks to help get enough data to build an accurate linear model for the relationship between base-pair size and repeat length. So on this plot, each dot is an individual peak, with the colour indicating each sample, with the y-axis is the repeat length called from the user-supplied value in the metadata and the value assigned to each peak, with the x-axis showing the corresponding base-pair size.
}
\examples{


fsa_list <- lapply(cell_line_fsa_list[16:19], function(x) x$clone())

find_ladders(fsa_list, show_progress_bar = FALSE)

fragments_list <- find_fragments(fsa_list, min_bp_size = 300)

test_alleles <- find_alleles(
  fragments_list 
)

add_metadata(
  fragments_list,
  metadata
)


call_repeats(
  fragments_list = fragments_list,
  correction = "repeat"
)

# traces of bp size shows traces at different sizes
plot_repeat_correction_model(
  fragments_list,
  batch_run_id_subset = "20230414"
)


}
