% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timelineS.R
\name{timelineS}
\alias{timelineS}
\title{Timeline with Event Labels}
\usage{
timelineS(df, main = NA, xlab = NA, buffer.days = 600,
         line.width = 5, line.color = "gray44",
         scale = "year", scale.format = "\%Y", scale.font = 2, scale.orient = 1,
         scale.above = FALSE, scale.cex = 1, scale.tickwidth = 2,
         labels = paste(df[[1]], df[[2]]), label.direction = "downup",
         label.length = c(0.5,0.5,0.8,0.8), label.position = c(1,3),
         label.color = "gray44", label.cex = 0.8, label.font = 1, label.angle = 0,
         pch = 20, point.cex = 1, point.color = "gray44")
}
\arguments{
\item{df}{Data frame for events and dates. First column for event names and second column for dates in \code{Date} class.}

\item{main}{Title of the plot.}

\item{xlab}{X axis label.}

\item{buffer.days}{Additional days to add before and after the event dates on the timeline. Default is 600 days.}

\item{line.width}{Timeline width; default 5}

\item{line.color}{Timeline color.}

\item{scale}{Scale on timeline. One of \code{"year","quarter", "month", "week" or "day"}. See \code{\link{seq.Date}}.}

\item{scale.format}{Scale format; default \code{"\%Y"}.}

\item{scale.font}{Integer specifying font of scale. Default is 2. (1:plain, 2:bold, 3:italic, 4:bold italic, 5:symbol).}

\item{scale.orient}{Orientation of scale; default 1(upright)}

\item{scale.above}{If \code{TRUE}, the scale shows above the line.}

\item{scale.cex}{Scale font size relative to cex.}

\item{scale.tickwidth}{Width of scale tick; default 2.}

\item{labels}{Event labels. Events and corresponding dates as default.}

\item{label.direction}{Direction of labels from timeline. \code{"downup","updown","up", or "down"}, default is \code{"downup"}. See details.}

\item{label.length}{Distance of event label from the timeline. Could be a single value or a vector of lengths.
Default is c(0.5, 0.5, 0.8, 0.8). See details.}

\item{label.position}{Integer specifying label positions; default c(1,3). See details.}

\item{label.color}{Label color(s).}

\item{label.cex}{Font size(s) of event labels; default 0.8.}

\item{label.font}{Integer specifying label font; default 1.}

\item{label.angle}{Angle of text in the label.}

\item{pch}{End point symbol(s).}

\item{point.cex}{End points size(s).}

\item{point.color}{End points color(s).}
}
\description{
Plots a horizontal timeline with event descriptions at corresponding dates.
}
\details{
\code{label.direction} indicates the direction of event labels from timeline. \code{"downup"} and \code{"updown"} plots
alternating labels; \code{"up"} puts all the labels above and \code{"down"} below the timeline.

\code{label.length} could be a single number or a numeric vector. For label directions  \code{"downup"} and \code{"updown"}, use between 0 and 0.9, and for
\code{"up"} and \code{"down"}, use between 0 and 1.6.
For example, \code{label.length = 0.5} produces all the labels at equal lengths, and \code{label.length = c(0.5,0.5,0.8,0.8)}
repeats the sequence of lengths.

The positions for \code{label.position} are 1: below 2: left 3: above 4: right.
}
\examples{
### Default down-up labels
timelineS(mj_life, main = "Life of Michael Jackson")

### Labels above timeline and other change in aesthetics
timelineS(mj_life, main = "Life of Michael Jackson",
label.direction = "up", label.length = c(0.2,0.8,0.4,1.2), label.position = 3,
line.color = "blue", label.color = "blue", point.color = "blue", pch = "-")

}
\author{
Dahee Lee
}
\seealso{
\code{\link{axis.Date}}, \code{\link{timelineG}}, \code{\link{durCalc}}, \code{\link{durPlot}}
}

