% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise}
\alias{summarise}
\alias{summarise.ee.imagecollection.ImageCollection}
\alias{summarise.tidyee}
\title{Summary pixel-level stats for ee$ImageCollection or tidyrgee objects with ImageCollections}
\usage{
\method{summarise}{ee.imagecollection.ImageCollection}(.data, stat, ...)

\method{summarise}{tidyee}(.data, stat, ..., join_bands = TRUE)
}
\arguments{
\item{.data}{ee$Image or ee$ImageCollection}

\item{stat}{\code{character} stat/function to apply}

\item{...}{other arguments}

\item{join_bands}{\code{logical} (default= TRUE) if multiple stats selected should bands be joined?}
}
\value{
ee$Image or ee$ImageCollection where pixels are summarised by group_by and stat

ee$Image or ee$ImageCollection where pixels are summarised by group_by and stat

ee$Image or ee$ImageCollection where pixels are summarised by group_by and stat
}
\description{
Summary pixel-level stats for ee$ImageCollection or tidyrgee objects with ImageCollections
}
\examples{
\dontrun{
library(tidyrgee)
library(rgee)
ee_Initialize()
modis_ic <- ee$ImageCollection("MODIS/006/MOD13Q1")
modis_ic |>
   filter(date>="2016-01-01",date<="2019-12-31") |>
   group_by(year) |>
   summarise(stat="max")
}
}
\seealso{
\code{\link[dplyr]{summarise}} for information about summarise on normal data tables.
}
