% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_neighbor_adaptive.R
\name{update.nearest_neighbor_adaptive}
\alias{update.nearest_neighbor_adaptive}
\title{Updating a model specification.}
\usage{
\method{update}{nearest_neighbor_adaptive}(
  object,
  parameters = NULL,
  neighbors = NULL,
  neighborhood = NULL,
  matrix_diagonal = NULL,
  weighted = NULL,
  sphere = NULL,
  num_comp = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{object}{A model specification.}

\item{parameters}{A 1-row tibble or named list with main parameters to
update. Use either parameters or the main arguments directly when updating.
If the main arguments are used, these will supersede the values in
parameters. Also, using engine arguments in this object will result in an
error.}

\item{neighbors}{The number of data points used for final classification.}

\item{neighborhood}{The number of data points used to calculate between and
within class covariance.}

\item{matrix_diagonal}{Diagonal elements of a diagonal matrix. 1 is the
identity
matrix.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.
Only sub_dann engine.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc:ncoord]{fpc::ncoord()}}
for details. Only sub_dann engine.}

\item{num_comp}{Dimension of subspace used by dann. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for
details. Only sub_dann engine.}

\item{fresh}{A logical for whether the arguments should be modified in-place
or replaced wholesale.}

\item{...}{Not used for update().}
}
\description{
If parameters of a model specification need to be modified,
update() can be used in lieu of recreating the object from scratch.
}
