% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_detections.R
\name{format_detects}
\alias{format_detects}
\title{Format Detections for filteRjsats}
\usage{
format_detects(
  data,
  var_Id,
  var_datetime_local,
  var_frequency = NULL,
  var_receiver_serial,
  var_receiver_make = NULL,
  local_time_zone,
  time_format
)
}
\arguments{
\item{data}{the detection dataframe with columns for individual receivers,
tag IDs,datetime, and the expected ping rate.}

\item{var_Id}{the column name, in quotes, which identifies the individual
transmitter/tag/organism identifier.}

\item{var_datetime_local}{the column name, in quotes, which identifies the
date and time of the detection event. This column should already have been converted
to POSIXct format and should be converted to the local timezone.}

\item{var_frequency}{the column name, in quotes, which identifies the maximum
temporal frequency at which transmitters in organisms emit a detectable
signal, only for use before JSATS filtering.}

\item{var_receiver_serial}{the column name, in quotes, which identifies the
serial number of the detection receiver}

\item{var_receiver_make}{the column name, in quotes, which identifies the
make or brand of the detection receiver. Must be one of "ATS", "Lotek", or
"Tekno", only for use before JSATS filtering.}

\item{local_time_zone}{the local timezone used for analyses. Uses tz database
names (e.g. "America/Los_Angeles" for Pacific Time)}

\item{time_format}{a string value indicating the datetime format of all time
fields}
}
\value{
A standardized detection dataframe which can be read by filteRjsats
}
\description{
This function takes a detection dataframe from a single receiver and
reformats specific columns so that they can be read by the filtering
functions in filteRjsats package
}
\examples{
#format the detection data
format_detects(data = raw_detections,
               var_Id = "tag_id",
               var_datetime_local = "local_time",
               var_receiver_serial = "serial",
               local_time_zone = "America/Los_Angeles",
               time_format = "\%Y-\%m-\%d \%H:\%M:\%S")
}
