% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{filtered_detections}
\alias{filtered_detections}
\title{Example Completely Filtered Detection Data}
\format{
## `filtered_detections`
A data frame with 41,000 rows and 26 columns:
\describe{
  \item{ReceiverSN}{The serial number of the detecting receiver}
  \item{DateTime_Local}{the local time of the detection (tz = America/Los_Angeles)}
  \item{Tag_Code}{The hexadecimal acoustic tag ID code}
  \item{CheckMBP}{A calculated field from the prefilter checking the
   time between acoustic transmissions from the same tag was >0.3secs}
  \item{TagInFile}{A calculated field from the add_fish filter which
   queries whether the tag code of the detection is associated with an
   organism.}
  \item{fish_type}{Generally a strain, run, and species of fish (e.g.
  Nimbus Fall Chinook = Fall-run Chinook Salmon from Nimbus Hatchery)}
  \item{org_release_Date}{The release date and time of the fish}
  \item{release_location}{The coded name of the release site}
  \item{length}{The length of the fish in millimeters}
  \item{weight}{The weight of the fish in grams}
  \item{tag_weight}{The weight of the implanted acoustic tag}
  \item{tag_model}{The model number of the implanted acoustic tag}
  \item{tag_pulse_rate_interval_nominal}{The pulse rate interval (time
   between transmissions) of the implanted tag, as reported by the
   manufacturer}
  \item{tag_life}{The expected number of days the tag should continue to
   transmit, as reported by the manufacturer}
  \item{CheckDT}{A calculated field which checks whether the detection
   occurred after the release of the fish}
  \item{CheckBattLife}{A calculated field which checks whether the detection
   occurred before the tag battery is expected to expire (2x tag life)}
  \item{dep_id}{A unique id is created for each receiver deployment}
  \item{Make}{The brand of the acoustic receiver}
  \item{latitude}{The decimal degree latitude (WGS1984) of the acoustic
  receiver at deployment}
  \item{longitude}{The decimal degree longitude (WGS1984) of the acoustic
  receiver at deployment}
  \item{receiver_location}{The site name of an individual receiver, often
  more than one `receiver_location` is found at a `receiver_general_location`}
  \item{receiver_general_location}{The more general geographic name of the
  location of the receiver}
  \item{receiver_river_km}{The number of river kilometers the receiver is
  from the Golden Gate Bridge}
  \item{receiver_start}{The start time of the reciever (generally when it
  was deployed)}
  \item{receiver_end}{The end time of the receiver (generally when it was
  retrieved)}
}
}
\source{
Data collected by the California Department of Water Resources 2021
}
\usage{
filtered_detections
}
\description{
An example dataset of real acoustic telemetry detections of fish at several
receivers within the California Central Valley from 2021. These detections
have already been been processed using `prefilter()` and `add_org()`.
}
\keyword{datasets}
