% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_proc.R
\name{tau_proc}
\alias{tau_proc}
\title{Estimate the Tau Process with/without cure fraction}
\usage{
tau_proc(data, t = NULL, cure = FALSE)
}
\arguments{
\item{data}{a data.frame consisting of \code{arm}, \code{surv.time}, \code{event}.}

\item{t}{a sequence of specified times. If the user do not specify the sequence, the default is an equally-spaced sequence from 0 to the last identified time.}

\item{cure}{a boolean variable indicating whether to consider the cure fractions.}
}
\value{
an object of class "tau_process" with components
\tabular{ll}{
\code{t} \tab the specified sequence of time points \cr
\tab \cr
\code{vals_tau_proc} \tab the estimated value of tau measure at given time \cr
\tab \cr
\code{cure} \tab a boolean variable indicating whether to consider the cure fraction \cr
\tab \cr
\code{cure_rates} \tab the estimated cure rates for Group 0 and Group 1, respectively \cr
}
}
\description{
Estimate the Tau Process with/without cure fraction
}
\details{
The estimation method proposed by Yi-Cheng Tai, Weijing Wang and Martin T. Wells to estimate tau process with or without cure fraction.
}
\examples{
tau_proc(data = pbc)
}
