% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table2.R
\name{table2}
\alias{table2}
\title{Table 2}
\usage{
table2(
  x,
  y,
  data,
  y_time = NULL,
  strata = NULL,
  adj = c(),
  div = list(),
  div_num = list(),
  ref = c(),
  ref_num = c(),
  continuous = FALSE,
  case = 2,
  method = "general",
  outformat = 2
)
}
\arguments{
\item{x}{A string. The independent variable to be summarized given as a string.}

\item{y}{A string. The dependent variable to be summarized given as a string.}

\item{data}{A data frame in which these variables exist.}

\item{y_time}{A string. The survival time variable to be summarized given as a string. It only works when \code{method = "cox"}.}

\item{strata}{A string. The paired variable to be summarized given as a string. It only works when \code{method = "con_logistic"}.}

\item{adj}{A vector of strings, default = \code{c()}. Moderator variables to be summarized given as a character vector.}

\item{div}{A list containing Positive int greater than 1 or integer vector, If a positive integer greater than 1, it is the number of factor levels when x is split by quantile statistics. If a vector of integers, it is the strategy of grouping x by quantile statistics and then merging groups.}

\item{div_num}{A list containing numeric vectors, Elements in the list are custom values, and x can be split into at least two levels by elements in the list.}

\item{ref}{A vector of integers. The control level of factor levels when x is split by quantile statistics.}

\item{ref_num}{A vector of integers. The control level of factor levels when x is split by custom values.}

\item{continuous}{Bool, default \code{= FALSE}. If default, then does not output the result when the independent variable is regarded as a continuous variable.}

\item{case}{A vector of integers, default \code{= 2}. The case level of y.}

\item{method}{(\code{"general"}, \code{"logistic"}, \code{"con_logistic"}, \code{"cox"}), default \code{= "general"}.}

\item{outformat}{\code{1} or \code{2}, default \code{= 2}, Output format. It only works when \code{method = "general"}. The table ouput mean(sd) when \code{outformat=1} and ouput median(IQR) when \code{outformat=2}.}
}
\value{
An object researching influence factor.
}
\description{
' Table 2 ' was created through regression analysis to research influence factor. The four regression methods include general linear regression, logistic regression, conditional logistic regression and cox proportional hazards regression.
}
\examples{
## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
library(tableeasy)
data(pbc)
## Check variables
head(pbc)
##The censored data is not discussed here
pbc_full <- subset(pbc,status!=0)
pbc_full$status <- pbc_full$status-1
## Make categorical variables factors
varsToFactor <- c('status','trt','ascites','hepato','spiders','edema','stage','sex')
pbc_full[varsToFactor] <- lapply(pbc_full[varsToFactor], factor)

## Moderator variables
adj_pbc <- c('age','alk.phos','ast')

## General linear regression:
table2(x = 'albumin', y = 'bili',
       adj = c(), data = pbc_full,
       div = list(5,c(2,3)), div_num = list(c(3.2,4)),
       ref = c(2,1), ref_num = c(2),
       outformat = 2)

## Logistic regression:
table2(x ='albumin', y = 'status',
       adj = adj_pbc, data = pbc_full,
       div = list(5,c(2,3)),
       method ='logistic')

## Conditional logistic regression:
table2(x = 'albumin', y = 'status', strata = 'trt',
       adj = adj_pbc, data = pbc_full,
       div = list(5,c(2,3)),
       method = 'con_logistic')

## Cox proportional hazards regression:
table2(x = 'albumin', y = 'status', y_time = 'time',
       adj = adj_pbc, data = pbc_full,
       div = list(5,c(2,3)),
       method = 'cox')
}
