% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.sylly.lang.R
\name{install.sylly.lang}
\alias{install.sylly.lang}
\title{Install language support packages}
\usage{
install.sylly.lang(
  lang,
  repos = "https://undocumeantit.github.io/repos/l10n/",
  ...
)
}
\arguments{
\item{lang}{Character vector,
      one or more valid language identifiers (like \code{en} for English or \code{de}
for German).}

\item{repos}{The URL to additional repositories to query. You should probably leave this to the
default, but if you would like to use a third party repository, you're free to do so. The
value is temporarily appended to the repos currently returned by \code{getOption("repos")}.}

\item{...}{Additional options for \code{install.packages}.}
}
\value{
Does not return any useful objects,
      just calls \code{\link[utils:install.packages]{install.packages}}.
}
\description{
This is a wrapper for \code{\link[utils:install.packages]{install.packages}},
      making it more
convenient to install additional language support packages for sylly.
}
\details{
For a list of currently available language packages see \code{\link[sylly:available.sylly.lang]{available.sylly.lang}}.
See \code{\link[sylly:set.hyph.support]{set.hyph.support}} for more details on sylly's language support in general.
}
\examples{
\dontrun{
# install support for German
install.sylly.lang("de")
# load the package
library("sylly.de")
}
}
\seealso{
\code{\link[utils:install.packages]{install.packages}},
      \code{\link[sylly:available.sylly.lang]{available.sylly.lang}}
}
