% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smthdirectEST.R
\name{fhModel}
\alias{fhModel}
\title{Calculate smoothed direct estimates}
\usage{
fhModel(
  data,
  cluster.info,
  admin.info = NULL,
  admin,
  CI = 0.95,
  model = c("bym2", "iid"),
  aggregation = FALSE
)
}
\arguments{
\item{data}{dataframe that contains the indicator of interests, output of getDHSindicator function}

\item{cluster.info}{list contains data and wrong.points. data contains admin 1 and admin 2 information and coordinates for each cluster. wrong.points. contains cluster id for cluster without coordinates or admin 1 information. Output of getDHSindicator function}

\item{admin.info}{list contains data and mat, data contains population and urban/rural proportion at specific admin level and mat is the adjacency matrix, output of adminInfo function}

\item{admin}{admin level for the model}

\item{CI}{Credible interval to be used. Default to 0.95.}

\item{model}{smoothing model used in the random effect. Options are independent ("iid") or spatial ("bym2").}

\item{aggregation}{whether or not report aggregation results.}
}
\value{
This function returns the dataset that contain district name and population for given  tiff files and polygons of admin level,
}
\description{
This function calculate smoothed direct estimates at given admin level.
}
\examples{
\dontrun{
geo <- getDHSgeo(country = "Zambia", year = 2018)
data(ZambiaAdm1)
data(ZambiaAdm2)
data(ZambiaPopWomen)
cluster.info <- clusterInfo(geo = geo,
                            poly.adm1 = ZambiaAdm1,
                            poly.adm2 = ZambiaAdm2)

dhsData <- getDHSdata(country = "Zambia",
                                 indicator = "ancvisit4+",
                                 year = 2018)

data <- getDHSindicator(dhsData, indicator = "ancvisit4+")
admin.info1 <- adminInfo(poly.adm = ZambiaAdm1,
                        admin = 1,
                        agg.pop =ZambiaPopWomen$admin1_pop,
                        proportion = ZambiaPopWomen$admin1_urban)
smth_res_ad1 <- fhModel(data,
                       cluster.info = cluster.info,
                       admin.info = admin.info1,
                       admin = 1,
                       model = "bym2",
                       aggregation = F)
smth_res_ad1
}

}
\author{
Qianyu Dong
}
