% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPlot.R
\name{survPlot}
\alias{survPlot}
\title{Setup for a plot for survival data without the curves.}
\usage{
survPlot(
  main = "",
  title.xaxis = "",
  title.yaxis = "",
  xmin = 0,
  xmax,
  ymin = -0.02,
  ymax = 1.02,
  ypercent = TRUE,
  title.nrAtRisk = "number at risk",
  space.nrAtRisk = 0,
  interval.xaxis,
  interval.yaxis,
  las.xaxis = 1,
  las.yaxis = 1,
  font.xaxis = 1,
  font.yaxis = 1,
  cex.xaxis = 1,
  cex.yaxis = 1,
  points.xaxis,
  points.yaxis,
  labels.xaxis,
  labels.yaxis,
  font.nrAtRiskTitle = 1,
  cex.nrAtRiskTitle = 1
)
}
\arguments{
\item{main}{Title of the plot, Default is "".}

\item{title.xaxis}{Title of the x-axis. Default is "".}

\item{title.yaxis}{Title of the y-axis. Default is "".}

\item{xmin}{Minimum for the x (Time) - axis. Default is 0.}

\item{xmax}{Maximum of the x (time) axis. No default, must be specified.}

\item{ymin}{Minimum of the y-axis. Default is -0.02}

\item{ymax}{Maximum of the y-axis. Default is 1.02}

\item{ypercent}{Specifies if the Unit of the y-axis is ratio (usually 0-1)
or percentage (0-100), Default is TRUE (0-100). Equals yscale=100.}

\item{title.nrAtRisk}{Label for the number at risk region. Default is
"number at risk", other meaningful value is "patients at risk", or  
translations in any language for example. Not plotted if space.nrAtRisk is 0}

\item{space.nrAtRisk}{Space (usually around 0.2-0.5) below the plot to draw
the values of number at risk. Default is 0.}

\item{interval.xaxis}{Interval at which the ticks of the x-axis are drawn.
Default depends on the size of the plot.}

\item{interval.yaxis}{Interval at which the ticks of the y-axis are drawn.
Default depends on the size of the plot.}

\item{las.xaxis}{Orientation of the labels of the x-axis. Default is 1
(horizontal).}

\item{las.yaxis}{Orientation of the labels of the y-axis. Default is 1
(horizontal).}

\item{font.xaxis}{Font-type for the labels of the x-axis. Default is 1.}

\item{font.yaxis}{Font-type for the labels of the y-axis. Default is 1.}

\item{cex.xaxis}{Font-size for the labels of the x-axis. Default is 1.}

\item{cex.yaxis}{Font-size for the labels of the y-axis. Default is 1.}

\item{points.xaxis}{Exact position of the ticks of the x-axis. Overwrites
the values of interval.xaxis. Usually not required.}

\item{points.yaxis}{Exact position of the ticks of the y-axis. Overwrites
the values of interval.yaxis. Usually not required.}

\item{labels.xaxis}{Label for the ticks of the x-axis. Only valid if 
points are specified. Must be same length like points.}

\item{labels.yaxis}{Label for the ticks of the y-axis. Only valid if 
points are specified. Must be same length like points.}

\item{font.nrAtRiskTitle}{Font type of the title of the nr-at-Risk Space
Default is 1.}

\item{cex.nrAtRiskTitle}{Font size of the title of the nr-at-Risk Space
Default is 1.}
}
\value{
Draws an empty plot optimized for survival-curves.
}
\description{
This function draws the confident interval area of one group of a survfit 
object. For Competitive risk analysis, the event number needs to be 
specified. 
To get a nice graph, the function should be runned after one made an empty 
plot, and before drawing the actual curves (Thus the area is underlining
to the curves). If two curves are drawn which confident intervals overlap
transparency should be added to the colors.
}
\examples{
  require(survival)
  aml_model <- with(aml, survfit(Surv(time, status)~x))
  col1 <- adjustcolor("red",0.2); col2 <- adjustcolor("blue",0.2)
  survPlot(xmax=50, space.nrAtRisk=0.32)
  confIntArea(aml_model, col=col1, group=1)
  confIntArea(aml_model, col=col2, group=2)
  survCurve(aml_model, group=1)
  survCurve(aml_model, group=2, lty=2)
  nrAtRisk(aml_model, group=1, y=-0.17, bgcol.flag=col1, label="maintain")
  nrAtRisk(aml_model, group=2, y=-0.24, bgcol.flag=col2, lty.flag=2, label="non-maint.")
}
