% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrAtRisk.R
\name{nrAtRisk}
\alias{nrAtRisk}
\title{Adds number at risk of a survival model to a plot.}
\usage{
nrAtRisk(
  x,
  group,
  ypos = 0.08,
  times,
  interval.times,
  zero.adjust = TRUE,
  zero.value,
  font.text = 1,
  cex.text = 1,
  col.text = "black",
  cex.nr,
  col.nr,
  font.nr,
  label,
  xpos.lab,
  cex.lab,
  col.lab,
  font.lab,
  lty.flag,
  lwd.flag,
  bgcol.flag,
  lncol.flag,
  xlim.flag
)
}
\arguments{
\item{x}{A survfit (survival-package) or a Cuminc (mstate-package) object.}

\item{group}{The number of the group (=strata) of which the confidence interval 
should be plotted. If the survfit-object has only one strata, this
argument can be omitted.}

\item{ypos}{A numeric value for the position at the y-axis.}

\item{times}{An optional vector of numeric values specifying at which times
(x-axis) the number at risk are calculated and plotted. If not specified, 
the defaults depends on "interval.times" value if available, or
the size of the plot.}

\item{interval.times}{An optional numeric value which specifies the interval
at which the number at risk values are plotted. Is overwritten by times. If 
not specified, the value depends on the size of the plot.}

\item{zero.adjust}{A logical value. If true, the number at risk at time 0 is not
plotted at the precise position, but slightly adjusted to the left to prevent
the value to be cut-off by the plot margins. Also, the value at x=0 is plotted 
if true. Default is TRUE.}

\item{zero.value}{A numeric value or string that overwrites the nr at
risk value at x=0 if specified (only if zero.adjust is TRUE).}

\item{font.text}{Font of the text (nr at risk and label). Default is 1.}

\item{cex.text}{Font-size of the text (nr at risk and label). Default is 1.}

\item{col.text}{Colour of the text (nr at risk and label). Default is "black".}

\item{cex.nr}{Overwrites cex.text for the number-part.}

\item{col.nr}{Overwrites col.text for the number-part.}

\item{font.nr}{Overwrites font.text for the number-part.}

\item{label}{String for the group name.}

\item{xpos.lab}{x-position of the label, default is near the right border
of the plot.}

\item{cex.lab}{Overwrites cex.text for the label-part.}

\item{col.lab}{Overwrites col.text for the label-part.}

\item{font.lab}{Overwrites font.text for the label-part.}

\item{lty.flag}{Line-type of the flag. Value is 1 if not specified.}

\item{lwd.flag}{Line-wide of the flag. Value is 1 if not specified.}

\item{bgcol.flag}{Background-color of the flag (corresponding to the 
color of the confidence interval in the plot). No color if not value is
specified.}

\item{lncol.flag}{color of the line of the flag. Default is "black".}

\item{xlim.flag}{Vector with two values, defining the beginning and end of the 
flag on the x-axis. Default depends on the size of the plot.}
}
\value{
Draws the number at risk to an existing plot.
}
\description{
This function adds the number at risk of one group (strata) of
a survfit object to an existing plot. If label is specified, it draws
a label for the group right to the number at risks. If any elements of
the "flag" is specified, it also draws a small identifier, with which 
the corresponding curves / confidence intervals of the plot can be
identified near to the label.
}
\examples{
  require(survival)
  aml_model <- with(aml, survfit(Surv(time, status)~x))
  col1 <- adjustcolor("red",0.2); col2 <- adjustcolor("blue",0.2)
  survPlot(xmax=50, space.nrAtRisk=0.32)
  confIntArea(aml_model, col=col1, group=1)
  confIntArea(aml_model, col=col2, group=2)
  survCurve(aml_model, group=1)
  survCurve(aml_model, group=2, lty=2)
  nrAtRisk(aml_model, group=1, y=-0.17, bgcol.flag=col1, label="maintain")
  nrAtRisk(aml_model, group=2, y=-0.24, bgcol.flag=col2, lty.flag=2, label="non-maint.")
}
