% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levenes.test.R
\name{levenes.test}
\alias{levenes.test}
\title{Levene's Test for Homogeneity of Variance}
\usage{
levenes.test(y, group)
}
\arguments{
\item{y}{outcome variable of interest, given as a numeric object.}

\item{group}{a factor or character object with two levels indicating group membership.}
}
\value{
An anova table containing test results: two values for degrees of freedom, the \emph{F}-value, and the \emph{p}-value.
}
\description{
Function to test the homogeneity of variance for two populations, an assumption of the independent samples t-test. The null hypothesis tested is that the two population variances are equal; the alternative is that the two population variances are not equal.
}
\examples{
# using simple data frame
value = c(7,2,4,4,8,3,61,2,80,4)
grp = rep(c("A","B"), each = 5)
ex_data = data.frame(value = value, grp = grp)
levenes.test(ex_data$value, group = ex_data$grp)

# using variable without NA values
levenes.test(NELS$famsize, group = NELS$gender)

# using variable with NA values
levenes.test(NELS$achrdg12, group = NELS$gender)
}
\seealso{
\code{\link[stats]{t.test}}
}
