% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.mean.R
\name{boot.mean}
\alias{boot.mean}
\title{Bootstrapped Mean}
\usage{
boot.mean(x, B, n = length(x))
}
\arguments{
\item{x}{original sample, given as a numeric or logical object, to be used to generate bootstrapped samples.}

\item{B}{number of bootstrapped samples to be generated by randomly sampling with replacement.}

\item{n}{size of each bootstrapped sample. Default setting is the size of the original sample.}
}
\value{
A list with components:
\item{Replications}{number of bootstrapped means computed.}
\item{mean}{mean of bootstrapped means.}
\item{se}{standard error, estimated as the standard deviation of bootstrapped means.}
\item{bootstrap.samples}{means of bootstrapped samples.}
}
\description{
Function to obtain a sampling distribution of means by bootstrapping.
}
\examples{
# using simple vector
a = 1:10
set.seed(1234)
boot.mean(a, B = 500)

# using variable from data frame
set.seed(1234)
boot.mean(Framingham$AGE3, B = 1000)
}
