% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/37_leadingFY1PE.R
\name{leadingFY1PE}
\alias{leadingFY1PE}
\title{Calculates Leading Price to Earning Multiple based on the mean of the current fiscal year (FY1 = Fiscal Year 1) forecasts.}
\usage{
leadingFY1PE(currentShPr, FY1EPS)
}
\arguments{
\item{currentShPr}{number.}

\item{FY1EPS}{number.}
}
\value{
Input values to two arguments  \code{currentShPr} and \code{FY1EPS}.
}
\description{
Applying the fiscal-year concept, Leading PE can be computed in two ways: first, based on the mean of the current fiscal year (FY1 = Fiscal Year 1) forecasts, for which analysts may have actual EPS in hand for some quarters; second, based on the following fiscal year (FY2 = Fiscal Year 2) forecasts, which must be based entirely on forecasts by analysts (Jerald E. Pinto, 2020).
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{leadingFY1PE} is developed for computing Leading PE Multiple based on the mean of the current fiscal year (FY1)  for the values passed to its two arguments. Here, \code{currentShPr} is the current Share Price and \code{FY1EPS} is the mean of the current fiscal year (FY1 = Fiscal Year 1) forecasts, for which analysts may have actual EPS in hand for some quarters.
}
\examples{
leadingFY1PE(currentShPr=184.15,FY1EPS=16.19)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
