% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear-spherical-spline.R
\name{knots_quantile}
\alias{knots_quantile}
\title{Generate knots for the piecewise geodesic curve based on the quantiles}
\usage{
knots_quantile(x, dimension, tiny = 1e-05)
}
\arguments{
\item{x}{Numeric vector representing time points for the geodesic path.}

\item{dimension}{Numeric vector the number of knots.}

\item{tiny}{Numeric value representing a small constant that slightly expands the boundary.}
}
\value{
Numeric vector representing knots sequence in the time domain.
}
\description{
This generates a sequence of knots for a given set of time points based on the quantiles.
}
\examples{
knots_quantile(seq(0, 1, length.out = 100), 10)
}
