%This file is part of the source code for
%SPGS: an R package for identifying statistical patterns in genomic sequences.
%Copyright (C) 2015  Universidad de Chile and INRIA-Chile
%
%This program is free software; you can redistribute it and/or modify
%it under the terms of the GNU General Public License as published by
%the Free Software Foundation; either version 2 of the License, or
%(at your option) any later version.
%
%This program is distributed in the hope that it will be useful,
%but WITHOUT ANY WARRANTY; without even the implied warranty of
%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%GNU General Public License for more details.
%
%A copy of Version 2 of the GNU Public License is available in the 
%share/licenses/gpl-2 file in the R installation directory or from 
%http://www.R-project.org/Licenses/GPL-2.

\name{spgs-package}
\alias{spgs-package}
\alias{spgs}
\docType{package}
\title{
\packageTitle{spgs}
}
\description{
provides functions for exploring and testing statistical properties and 
patterns in DNA sequences.
}
\details{
\tabular{ll}{
Package: \tab spgs \cr
Type: \tab Package\cr
License: \tab GPL (>= 2)\cr
}

This package provides a range of statistical tests for various properties of DNA
and/or other genomic sequences.  There are eight groups of functions:

\describe{
\item{Testing for Chargaff's second parity rule in bacteria and other DNA sequences}{
\code{\link{chargaff0.test}}, \code{\link{chargaff1.test}}, \code{\link{chargaff2.test}},
\code{\link{chargaff.gibbs.test}}, \code{\link{oligoProfile}}
}
\item{Testing for purine-pyrimidine parity in viruses and other DNA sequences}{
\code{\link{ag.test}}, \code{\link{agct.test}}
}
\item{Testing for Bernoulli/Markov processes}{
\code{\link{markov.test}}, \code{\link{diid.test}}
}
\item{Independence tests}{
\code{\link{diffsign.test}}, \code{\link{turningpoint.test}}, 
\code{\link{rank.test}}, \code{\link{lb.test}}
}
\item{Tests for uniform distribution}{
\code{\link{ks.unif.test}}, \code{\link{chisq.unif.test}}
}
\item{Simulation of random vectors, stochastic matrices, Bernoulli processes and Markov chains }{
\code{\link{simulateMarkovChain}}, \code{\link{estimateMarkovChain}}, 
\code{\link{rstochvec}}, \code{\link{rstochmat}}, \code{\link{rcspr2mat}}
}
\item{Functions for obtaining the complement or reverse complement of a DNA sequence}{
\code{\link{complement}}, \code{\link{reverseComplement}}
}
\item{Functions for counting words/k-mers and cylinders in symbolic sequences}{
\code{\link{pair.counts}}, \code{\link{triple.counts}}, \code{\link{quadruple.counts}}, \code{\link{cylinder.counts}}
}
}

The word/k-mer counting functions are general and can deal with arbitrary 
symbolic sequences, not only DNA sequences.

Functions which take a DNA sequence as input are able to work with sequences 
stored as \code{SeqFastadna} objects generated by the \pkg{seqinr} package.
}
\author{
Andrew Hart and Servet Martínez

Maintainer: \packageMaintainer{spgs}
}
\references{
Hart, A.G. and Martínez, S. (2011)
Statistical testing of Chargaff's second parity rule in bacterial genome sequences.
\emph{Stoch. Models} \bold{27(2)}, 1--46.

Hart, A.G. and Martínez, S. (2014) 
Markovianness and Conditional Independence in Annotated Bacterial DNA.  
\emph{Stat. Appl. Genet. Mol. Biol.} \bold{13(6)}, 693-716.  arXiv:1311.4411 [q-bio.QM].

Hart, A.G. and Martínez, S. (2012)
A Gibbs approach to Chargaff's second parity rule.
\emph{J. Stat. Phys.} \bold{146(2)}, 408-422.  arXiv:1105.0685 [math.pr].
}
\keyword{package}
\seealso{
\code{\link[seqinr:seqinr-package]{seqinr}}
}
