% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.panelReg}
\alias{plot.panelReg}
\title{Plot a \code{panelReg} Object.}
\usage{
\method{plot}{panelReg}(x, ...)
}
\arguments{
\item{x}{The result of a call to the \code{panelReg} function.}

\item{...}{Other graphical parameters such as line type, color, or axis labels.}
}
\description{
Plot the estimated baseline mean function. If \code{"se"} option of
  \code{panelReg} is not \code{"NULL"}, 95% point wise confidence
  interval is also plotted.
}
\examples{
data(blaTum)
## Plot the fit of bladder tumor data set
fm <- PanelSurv(id, time, count) ~ num + size + treatment
fit1 <- panelReg(fm, data=blaTum, method = "AEE", se = "Sandwich")
plot(fit1)

fit2 <- panelReg(fm, data=blaTum, method = "MLs", se = "NULL")
plot(fit2)
}
\seealso{
\code{\link{panelReg}} \code{\link{panelReg.object}}
}
