% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tprs.R
\name{computeTPRS}
\alias{computeTPRS}
\alias{arrangeTPRS}
\title{Create TPRS basis}
\usage{
computeTPRS(coords, maxdf, rearrange = TRUE, intercept = FALSE)

arrangeTPRS(tprs, intercept = FALSE)
}
\arguments{
\item{coords}{Data frame containing the coordinates.}

\item{maxdf}{Largest number of splines to include in TPRS basis}

\item{rearrange}{Logical indicator of whether to rearrange the columns of TPRS basis.}

\item{intercept}{Logical indicator of whether or not to remove the intercept column from the basis when \code{rearrange} is \code{TRUE}.}

\item{tprs}{Matrix of TPRS basis values (from \code{computeTPRS}).}
}
\value{
An \eqn{n}-by-\eqn{k} matrix of spline basis functions where \eqn{n} is the number of rows in \code{coords} and \eqn{k} is equal to \code{maxdf}
}
\description{
Compute TPRS basis for given spatial coordinates
}
\details{
\code{computeTPRS} creates a thin-plate regression spline (TPRS) basis from a two-dimensional set of coordinate locations using the \code{mgcv} package.

 The output from \code{mgcv} is structured to have the linear terms as the last columns of the matrix. Use \code{arrangeTPRS()} to arrange the matrix columns to be in order of increasing resolution. Specifically, it moves the last two columns to the left of the matrix and the third-from last column, which corresponds to the intercept, is optionally removed.
}
\examples{
x <- runif(100)
y <- runif(100)
mat <- computeTPRS(data.frame(x, y), maxdf=4)
}
