% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcPriors.R
\name{mcmcPriors}
\alias{mcmcPriors}
\title{mcmcPriors function}
\usage{
mcmcPriors(
  betaprior = NULL,
  omegaprior = NULL,
  etaprior = NULL,
  call = NULL,
  derivative = NULL
)
}
\arguments{
\item{betaprior}{prior for beta, the covariate effects}

\item{omegaprior}{prior for omega, the parameters of the baseline hazard}

\item{etaprior}{prior for eta, the parameters of the latent field}

\item{call}{function to evaluate the log-prior e.g. logindepGaussianprior}

\item{derivative}{function to evaluate the first and second derivatives of the prior}
}
\value{
an object of class mcmcPriors
}
\description{
A function to define priors for the MCMC.
}
\details{
The package \code{spatsurv} only provides functionality for the built-in Gaussian priors. However, the choice of prior is 
extensible by the user by creating functions similar to the functions \code{betapriorGauss}, \code{omegapriorGauss}, \code{etapriorGauss}, 
\code{indepGaussianprior} and \code{derivindepGaussianprior}: the first three of which provide a mechanism for storing and retrieving the 
parameters of the priors; the fourth, a function for evaluating the log of the prior for a given set of parameter values; and the fifth, a 
function for evaluating the first and second derivatives of the log of the prior. It is assumed that parameters are a priori independent. 
The user interested in using other priors is encouraged to look at the structure of the five functions mentioned above.
}
\seealso{
\link{survspat}, \link{betapriorGauss}, \link{omegapriorGauss}, \link{etapriorGauss}, \link{indepGaussianprior}, \link{derivindepGaussianprior}
}
