% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot_points.R
\name{plot_points}
\alias{plot_points}
\title{Create interactive point map}
\usage{
plot_points(df, value, lon = "lon", lat = "lat", crs = 4326, at = NULL)
}
\arguments{
\item{df}{A data.frame containing columns for longitude and latitude.}

\item{value}{A string giving the name of the column in \code{df} to be
visualized.}

\item{lon}{A string with the name of the column containing longitude
values. Default is \code{"lon"}.}

\item{lat}{A string with the name of the column containing latitude
values. Default is \code{"lat"}.}

\item{crs}{Integer; EPSG code for the coordinate reference system.
Default is \code{4326}.}

\item{at}{Optional numeric vector; breakpoints used for visualization.}
}
\value{
An interactive \code{mapview} object.
}
\description{
Creates an interactive map for a data.frame containing
point coordinates, colored by a selected variable.
}
\examples{
\dontrun{
plot_points(Groningen, value = "amount")
}

}
