% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowerRelation.R
\name{PowerRelation}
\alias{PowerRelation}
\alias{is.PowerRelation}
\alias{print.PowerRelation}
\title{PowerRelation object}
\usage{
PowerRelation(
  equivalenceClasses,
  elements = NULL,
  coalitionLookup = NULL,
  elementLookup = NULL
)

is.PowerRelation(x, ...)

\method{print}{PowerRelation}(x, ...)
}
\arguments{
\item{equivalenceClasses}{A nested list of lists, each containing coalitions or groups represented as vectors that are in the same equivalence class.}

\item{elements}{Vector of elements in power relation. Only set this value if you know what you are doing. See Details for more.}

\item{coalitionLookup}{A function taking a vector parameter and returning an index. See return value for more details. Only set this value if you know what you are doing.}

\item{elementLookup}{A function taking an element and returning a list of 2-sized tuples. See return value for more details. Only set this value if you know what you are doing.}

\item{x}{An \R object.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
\code{\link{PowerRelation}} object containing the following values:
\itemize{
\item \verb{$elements}: vector of elements
\item \verb{$eqs}: equivalence classes. Nested list of lists, each containing vectors representing groups of elements in the same equivalence class
\item \verb{$coalitionLookup}: \verb{function(v)} taking a coalition vector \code{v} and returning the equivalence class it belongs to. See \code{\link[=coalitionLookup]{coalitionLookup()}} for more.
\item \verb{$elementLookup}: \verb{function(e)} taking an element \code{e} and returning a list of 2-sized tuples. See \code{\link[=elementLookup]{elementLookup()}} for more.
}
}
\description{
Create a \code{PowerRelation} object.
}
\details{
A power relation describes the ordinal information between elements.
Here specifically, we are interested in the power relation between coalitions, or groups of elements.
Each coalition is assumed to be a \link[base:c]{vector} containing zero (empty coalition), one (singleton) or more elements.

\code{\link[=createPowerset]{createPowerset()}} offers a convenient way of creating a power set over a set of elements that can be used to call \code{PowerRelation()} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}.

Trying to figure out what equivalence class certain coalitions or elements belong to is quite common.
For these sets of problems, the functions \verb{$coalitionLookup(v)} and \verb{$elementLookup(e)} should be utilized.
We use some redundancy to speed up the lookup methods.
As such, it is highly discouraged to edit a \code{PowerRelation} object directly, as the different power relation representations will fall out of sync.
For more information, see the vignette: \code{vignette(package = 'socialranking')}

The \code{PowerRelation()} function expects a nested list of coalitions as input. For alternatives, see \code{\link[=as.PowerRelation]{as.PowerRelation()}}.
}
\section{Mathematical background}{


Let \eqn{N = \lbrace 1, ..., n \rbrace}{N = \{1, ..., n\}} be a finite set of \emph{elements} (also called players).
Any subset \eqn{S \subseteq N}{S \\subseteq N} is considered to be a group or coalition of elements,
where \eqn{\{\}}{\{\}} is referred to as the empty coalition, \eqn{\{i\}}{\{i\}} as a singleton (a coalition of size 1), and \eqn{N}{N} as the grand coalition.
The power set \eqn{2^N}{2^N} denotes the set of all subsets over \eqn{N}{N}.

Let \eqn{\mathcal{P} \subseteq 2^N}{P \\subseteq 2^N} be a collection of coalitions.
A \emph{power relation} on \eqn{\mathcal{P}}{P} is a total preorder \eqn{\succsim \subseteq \mathcal{P} \times \mathcal{P}}{>= \\subseteq P x P}.
That is, for any two coalitions \eqn{S, T \in \mathcal{P}}{S, T in P}, either \eqn{(S,T) \in \succsim}{(S,T) in >=}, or \eqn{(T,S) \in \succsim}{(T,S) in >=}, or both.
In other words, we can compare any two groups of elements in \eqn{\mathcal{P}}{P} and determine, if one group is better than, worse than, or equivalent to the other.

More commonly, the relation \eqn{(S,T) \in \succsim}{(S,T) in >=} is notated as \eqn{S \succsim T}{S >= T}.

\eqn{\mathcal{T}(\mathcal{P})}{T(P)} denotes the family of all power relations on every collection \eqn{\mathcal{P} \subseteq 2^N}{P \\subseteq 2^N}.
Given a power relation \eqn{\succsim \in \mathcal{T}(\mathcal{P})}{>= in T(P)}, \eqn{\sim}{~} denotes its symmetric part whereas \eqn{\succ}{>} its asymmetric part.
Let \eqn{S, T \in \mathcal{P}}{S, T in P}.
Then,

\deqn{
S \sim T \textrm{ if } S \succsim T \textrm{ and } T \succsim S,\\
S \succ T \textrm{ if } S \succsim T \textrm{ and not } T \succsim S.
}{
S ~ T if S >= T and T >= S,\\
S > T if S >= T and not T >= S.
}

Coalitions which are deemed equivalent (\eqn{S \sim T}{S ~ T}) can be collected into an equivalence class \eqn{\Sigma_i}{E_i}.
The list of equivalence classes forms a linear order, \eqn{\Sigma_1 \succ \Sigma_2 \succ \dots \succ \Sigma_m}{E_1 > E_2 > ... > E_m}.
}

\section{Mathematical example}{


As an example, consider the elements \eqn{N = \{\textrm{apple}, \textrm{banana}, \textrm{chocolate}\}}{N = \{apple, banana, chocolate\}}.
Each of them individually may go well with pancakes, but we are also interested in the combination of condiments.
If we consider all possibilities, we will have to compare the sets

\deqn{\mathcal{P} = 2^N = \{\{a,b,c\}, \{a,b\}, \{a,c\}, \{b,c\}, \{a\}, \{b\}, \{c\}, \{\}\}.}{P = 2^N = \{\{a,b,c\}, \{a,b\}, \{a,c\}, \{b,c\}, \{a\}, \{b\}, \{c\}, \{\}\}.}

Looking for a way to rank this group of objects, one may arrive at the following total preorder \eqn{\succsim \in \mathcal{T}(\mathcal{P})}{>= in T(P)}:

\deqn{\{b,c\} \succ (\{a\} \sim \{c\}) \succ \{b\} \succ \{\} \succ (\{a,b,c\} \sim \{a,b\} \sim \{a, c\}).}{>=: \{b,c\} > (\{a\} ~ \{c\}) > \{b\} > \{\} > (\{a,b,c\} ~ \{a,b\} ~ \{a, c\}).}

In this particular case, we get five equivalence classes.

\deqn{\Sigma_1 = \{\{b,c\}\}\\
\Sigma_2 = \{\{a\}, \{c\}\}\\
\Sigma_3 = \{\{b\}\}\\
\Sigma_4 = \{\{\}\}\\
\Sigma_5 = \{\{a,b,c\},\{a,b\},\{a,c\}\}
}{}

The power relation \eqn{\succsim}{>=} can be copy-pasted as a character string to the \code{\link[=as.PowerRelation]{as.PowerRelation()}} function (it should accept the special characters \eqn{\succsim}{>=} and \eqn{\sim}{~}).

\code{as.PowerRelation("{b,c} > ({a} ~ {c}) > {b} > {} > ({a,b,c} ~ {a,b} ~ {a,c})")}
}

\examples{
pr <- PowerRelation(list(
  list(c(1,2,3)),
  list(c(1, 2), 2, 3),
  list(c(2, 3), c()),
  list(c(1, 3)),
  list(1)
))

pr
# 123 > (12 ~ 2 ~ 3) > (23 ~ {}) > 13 > 1

stopifnot(pr$elements == 1:3)
stopifnot(pr$coalitionLookup(1) == 5)
stopifnot(pr$coalitionLookup(c()) == 3)
stopifnot(pr$coalitionLookup(c(1,2)) == 2)

# find coalitions an element appears in
for(t in pr$elementLookup(2)) {
  stopifnot(2 \%in\% pr$eqs[[t[1]]][[t[2]]])
}

# use createPowerset to help generate a valid function call
if(interactive())
  createPowerset(letters[1:3], result = "copy")

# pasted, rearranged using alt+up / alt+down in RStudio

# note that the function call looks different if elements are multiple characters long
if(interactive())
  createPowerset(c("apple", "banana", "chocolate"), result = "copy")

# pasted clipboard
PowerRelation(rlang::list2(
  list(c("banana", "chocolate")),
  list(c("apple"),
       c("chocolate")),
  list(c("banana")),
  list(c()),
  list(c("apple", "banana", "chocolate"),
       c("apple", "banana"),
       c("apple", "chocolate")),
))
# {banana, chocolate} > ({apple} ~ {chocolate}) > {banana} > {} > ...

}
\references{
\insertRef{2017axiomaticAndAlgorithmicPerspectives}{socialranking}

\insertRef{2019Lexcel}{socialranking}

\insertRef{2021Lexcel}{socialranking}
}
\seealso{
Other ways to create a \code{PowerRelation()} object using \code{\link[=as.PowerRelation]{as.PowerRelation()}}.
}
