% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothic_functions.R
\name{summary.smoothic}
\alias{summary.smoothic}
\alias{print.summary.smoothic}
\title{Summarising Smooth Information Criterion (SIC) Fits}
\usage{
\method{summary}{smoothic}(object, ...)
}
\arguments{
\item{object}{an object of class \dQuote{\code{smoothic}} which is the result
of a call to \code{\link{smoothic}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list containing the following components:
\itemize{
  \item \code{model} - the matched model from the \code{smoothic} object.
  \item \code{coefmat} - a typical coefficient matrix whose columns are the
  estimated regression coefficients, estimated standard errors (SEE) and p-values.
  \item \code{plike} - value of the penalized likelihood function.
  }
}
\description{
\code{summary} method class \dQuote{\code{smoothic}}
}
\examples{
# Sniffer Data --------------------
# MPR Model ----
results <- smoothic(
  formula = y ~ .,
  data = sniffer,
  family = "normal",
  model = "mpr"
)
summary(results)
}
\author{
Meadhbh O'Neill
}
