% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlink.test.R
\name{mlink.test}
\alias{mlink.test}
\title{Maximum Linkage spatial scan test}
\usage{
mlink.test(
  coords,
  cases,
  pop,
  w,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.1,
  ubpop = 0.5,
  ubd = 1,
  longlat = FALSE,
  cl = NULL
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{ubd}{A proportion in (0, 1].  The distance of
potential clusters must be no more than \code{ubd * m},
where \code{m} is the maximum intercentroid distance
between all coordinates.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}
}
\value{
Returns a \code{smerc_cluster} object.
}
\description{
\code{mlink.test} implements the Maximum Linkage spatial
scan test of Costa et al. (2012). Starting with a single
region as a current zone, new candidate zones are
constructed by combining the current zone with the
connected region that maximizes the resulting likelihood
ratio test statistic, with the added constraint that the
region has the maximum connections (i.e., shares a border
with) with the regions in the current zone.  This
procedure is repeated until the population or distance
upper bounds constraints are reached.  The same procedure
is repeated for each region.  The clusters returned are
non-overlapping, ordered from most significant to least
significant. The first cluster is the most likely to be a
cluster. If no significant clusters are found, then the
most likely cluster is returned (along with a warning).
}
\details{
The maximum intercentroid distance can be found by
executing the command:
\code{gedist(as.matrix(coords), longlat = longlat)},
based on the specified values of \code{coords} and
\code{longlat}.
}
\examples{
data(nydf)
data(nyw)
coords <- with(nydf, cbind(longitude, latitude))
out <- mlink.test(
  coords = coords, cases = floor(nydf$cases),
  pop = nydf$pop, w = nyw,
  alpha = 0.12, longlat = TRUE,
  nsim = 2, ubpop = 0.05, ubd = 0.1
)
# better plotting
if (require("sf", quietly = TRUE)) {
   data(nysf)
   plot(st_geometry(nysf), col = color.clusters(out))
}
}
\references{
Costa, M.A. and Assuncao, R.M. and Kulldorff,
  M. (2012) Constrained spanning tree algorithms for
  irregularly-shaped spatial clustering, Computational
  Statistics & Data Analysis, 56(6), 1771-1783.
  <doi:10.1016/j.csda.2011.11.001>
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.stat}}, \code{\link{scan.test}}
}
\author{
Joshua French
}
