% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex.test.R
\name{flex.test}
\alias{flex.test}
\title{Flexibly-shaped Spatial Scan Test}
\usage{
flex.test(
  coords,
  cases,
  pop,
  w,
  k = 10,
  ex = sum(cases)/sum(pop) * pop,
  type = "poisson",
  nsim = 499,
  alpha = 0.1,
  longlat = FALSE,
  cl = NULL,
  lonlat = longlat,
  ...
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{k}{An integer indicating the maximum number of
regions to inclue in a potential cluster.  Default is
10}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}

\item{lonlat}{Deprecated in favor of \code{longlat}.}

\item{...}{Not used.}
}
\value{
Returns a list of length two of class scan. The
  first element (clusters) is a list containing the
  significant, non-ovlappering clusters, and has the the
  following components:
}
\description{
\code{flex.test} performs the flexibly-shaped scan test
of Tango and Takahashi (2005).
}
\details{
The test is performed using the spatial scan test based
on the Poisson test statistic and a fixed number of
cases.  The first cluster is the most likely to be a
cluster.  If no significant clusters are found, then the
most likely cluster is returned (along with a warning).
}
\examples{
data(nydf)
data(nyw)
coords <- with(nydf, cbind(longitude, latitude))
out <- flex.test(
  coords = coords, cases = floor(nydf$cases),
  w = nyw, k = 3,
  pop = nydf$pop, nsim = 49,
  alpha = 0.12, longlat = TRUE
)

# better plotting
if (require("sf", quietly = TRUE)) {
   data(nysf)
   plot(st_geometry(nysf), col = color.clusters(out))
}
}
\references{
Tango, T., & Takahashi, K. (2005). A flexibly
  shaped spatial scan statistic for detecting clusters.
  International journal of health geographics, 4(1), 11.
  Kulldorff, M. (1997) A spatial scan statistic.
  Communications in Statistics -- Theory and Methods 26,
  1481-1496.
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.stat}}, \code{\link{scan.test}}
}
\author{
Joshua French
}
