% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testLibrary.R
\name{tests}
\alias{tests}
\alias{fixed}
\alias{compare}
\alias{fcompare}
\alias{rcompare}
\alias{random}
\title{Specify a statistical test to apply}
\usage{
fixed(
  xname,
  method = c("z", "t", "f", "chisq", "anova", "lr", "sa", "kr", "pb")
)

compare(model, method = c("lr", "pb"))

fcompare(model, method = c("lr", "kr", "pb"))

rcompare(model, method = c("lr", "pb"))

random()
}
\arguments{
\item{xname}{an explanatory variable to test (character).}

\item{method}{the type of test to apply (see Details).}

\item{model}{a null model for comparison (formula).}
}
\value{
A function which takes a fitted model as an argument and returns a single p-value.
}
\description{
Specify a statistical test to apply
}
\details{
\describe{
\item{\code{fixed}:}{
    Test a single fixed effect, specified by \code{xname}.}
\item{\code{compare}:}{
    Compare the current model to a smaller one specified by the formula \code{model}.}
\item{\code{fcompare}, \code{rcompare}:}{
    Similar to \code{compare}, but only the fixed/random part of the formula needs to be supplied.}
\item{\code{random}:}{
    Test the significance of a single random effect.}
}
}
\section{Methods}{


The \code{method} argument can be used to specify one of the following tests.
Note that \code{"z"} is an asymptotic approximation for models not fitted
with \code{\link[lme4]{glmer}} and \code{"kr"} will only work with models
fitted with \code{\link[lme4]{lmer}}.

\describe{
\item{\code{z}:}{
    Z-test for models fitted with \code{\link[lme4]{glmer}} (or \code{\link{glm}}),
    using the p-value from \code{\link[lme4]{summary.merMod}}.
    For models fitted with \code{\link[lme4]{lmer}}, this test can be used to
    treat the t-values from \code{\link[lme4]{summary.merMod}} as
    z-values, which is equivalent to assuming infinite degrees of freedom.
    This asymptotic approximation seems to perform well for even medium-sized
    data sets, as the denominator degrees of freedom are already quite large
    (cf. Baayen et al. 2008) even if calculating their exact value is
    analytically unsolved and computationally difficult (e.g. with
    Satterthwaite or Kenward-Roger approximations). Setting
    \code{alpha=0.045} is roughly equal to the t=2 threshold suggested by
    Baayen et al. (2008) and helps compensate for the slightly
    anti-conservative approximation.}
\item{\code{t}:}{
    T-test for models fitted with \code{\link{lm}}. Also available for mixed models
    when \code{\link[lmerTest]{lmerTest}} is installed, using the p-value calculated
    using the Satterthwaite approximation for the denominator degrees of
    freedom by default. This can be changed by setting \code{lmerTestDdf},
    see \code{\link{simrOptions}}.}
\item{\code{lr}:}{Likelihood ratio test, using \code{\link[lme4]{anova.merMod}}.}
\item{\code{f}:}{
     Wald F-test, using \code{\link[car:Anova]{car::Anova}}.
     Useful for examining categorical terms. For models fitted with
     \code{\link[lme4]{lmer}}, this should yield equivalent results to
     \code{method='kr'}. Uses Type-II tests by default, this can be changed
     by setting \code{carTestType}, see \code{\link{simrOptions}}.}
\item{\code{chisq}:}{
     Wald Chi-Square test, using \code{\link[car:Anova]{car::Anova}}.
     Please note that while this is much faster than the F-test computed with
     Kenward-Roger, it is also known to be anti-conservative, especially for
     small samples. Uses Type-II tests by default, this can be changed by
     setting \code{carTestType}, see \code{\link{simrOptions}}.}
\item{\code{anova}:}{
     ANOVA-style F-test, using \code{\link{anova}} and
     \code{\link[lmerTest:anova.lmerModLmerTest]{lmerTest::anova.lmerModLmerTest}}.
     For `lm`, this yields a Type-I (sequential) test (see \code{\link[=anova.lm]{anova}});
     to use other test types, use the F-tests provided by \code{car::Anova()}
     (see above). For \code{lmer}, this generates Type-II tests with
     Satterthwaite denominator degrees of freedom by default, this can be
     changed by setting \code{lmerTestDdf} and \code{lmerTestType}, see
     \code{\link{simrOptions}}.}
\item{\code{kr}:}{
    Kenward-Roger test, using \code{\link[pbkrtest]{KRmodcomp}}.
    This only applies to models fitted with \code{\link[lme4]{lmer}}, and compares models with
    different fixed effect specifications but equivalent random effects.}
\item{\code{pb}:}{
    Parametric bootstrap test, using \code{\link[pbkrtest]{PBmodcomp}}.
    This test will be very accurate, but is also very computationally expensive.}
}

Tests using \code{random} for a single random effect call \code{\link[RLRsim]{exactRLRT}}.
}

\examples{
lm1 <- lmer(y ~ x + (x|g), data=simdata)
lm0 <- lmer(y ~ x + (1|g), data=simdata)
anova(lm1, lm0)
compare(. ~ x + (1|g))(lm1)
rcompare(~ (1|g))(lm1)
\dontrun{powerSim(fm1, compare(. ~ x + (1|g)))}

}
\references{
Baayen, R. H., Davidson, D. J., and Bates, D. M. (2008). Mixed-effects modeling
with crossed random effects for subjects and items. Journal of Memory and Language, 59, 390--412.
}
