% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setShake.R
\name{setShake}
\alias{setShake}
\title{Custom shake animation}
\usage{
setShake(id = NULL, class = NULL, duration = 0.82)
}
\arguments{
\item{id}{Use this argument if you want to target an individual element.}

\item{class}{The element to which the shake should be applied.
For example, class is set to box.}

\item{duration}{Shake total duration. 0.82s by default.}
}
\description{
Allow to apply a shake animation on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyEffects)

  boxTag <- box(
   title = "A box",
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(

      setShake(class = "box"),
      setShake(id = "my-progress"),

      tags$h2("Add shake to the box class"),
      fluidRow(boxTag, boxTag),
      tags$h2("Add shake only to the first element using id"),
      tagAppendAttributes(
       progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE,
        vertical = TRUE
       ),
       id = "my-progress"
      ),
      progressBar(
       value = 50,
       status = "warning",
       size = "xs",
      )
     ),
     controlbar = dashboardControlbar(),
     title = "Shake Effect"
   ),
   server = function(input, output) { }
  )
}
}
