% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R, R/source_tblist.R
\name{rendering-step-attrition}
\alias{rendering-step-attrition}
\alias{.step_attrition}
\alias{.step_attrition.default}
\alias{.step_attrition.tblist}
\title{Generate output of attrition plot}
\usage{
.step_attrition(source, ...)

\method{.step_attrition}{default}(source, id, cohort, session, ...)

\method{.step_attrition}{tblist}(source, id, cohort, session, ...)
}
\arguments{
\item{source}{Source object.}

\item{...}{Extra arguments passed to specific method.}

\item{id}{Id of attrition output.}

\item{cohort}{Cohort object.}

\item{session}{Shiny session object.}
}
\value{
List of two objects: `render` and `output` defining rendering and
    output placeholder for step attrition plot feature.
}
\description{
The method should return list of two object:
\itemize{
  \item{\code{render} - Rendering expression of attrition output.}
  \item{\code{output} - Output expression related to rendering (with id equal to `id` parameter).}
}
For example:
\preformatted{
  list(
    render = shiny::renderPlot({
      cohort$show_attrition()
    }),
    output = shiny::plotOutput(id)
  )
}
}
\examples{
if (interactive()) {
  library(magrittr)
  library(shiny)
  library(cohortBuilder)
  library(shinyCohortBuilder)

  coh <- cohort(
    set_source(as.tblist(librarian)),
    step(
      filter(
        "range", id = "copies", dataset = "books",
        variable = "copies", range = c(5, 12)
      )
    ),
    step(
      filter(
        "range", id = "copies", dataset = "books",
        variable = "copies", range = c(6, 8)
      )
    )
  ) \%>\% run()

  ui <- fluidPage(
    div(id = "attrition")
  )

  server <- function(input, output, session) {
    rendering <- .step_attrition(
      coh$get_source(), id = "attr", cohort = coh, session = session, dataset = "books"
    )
    insertUI("#attrition", ui = rendering$output)
    output$attr <- rendering$render
  }

  shinyApp(ui, server)
}

}
\seealso{
\link{source-gui-layer}
}
