% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sentiment_terms.R
\name{extract_sentiment_terms}
\alias{extract_sentiment_terms}
\title{Extract Sentiment Words}
\usage{
extract_sentiment_terms(
  text.var,
  polarity_dt = lexicon::hash_sentiment_jockers_rinker,
  hyphen = "",
  retention_regex = "\\\\d:\\\\d|\\\\d\\\\s|[^[:alpha:]',;: ]",
  ...
)
}
\arguments{
\item{text.var}{The text variable.}

\item{polarity_dt}{A \pkg{data.table} of positive/negative words and
weights with x and y as column names.}

\item{hyphen}{The character string to replace hyphens with.  Default replaces
with nothing so 'sugar-free' becomes 'sugarfree'.  Setting \code{hyphen = " "}
would result in a space between words (e.g., 'sugar free').}

\item{retention_regex}{A regex of what characters to keep.  All other 
characters will be removed.  Note that when this is used all text is lower 
case format.  Only adjust this parameter if you really understand how it is 
used.  Note that swapping the \code{\\\\{p}} for \code{[^[:alpha:];:,\']} may 
retain more alpha letters but will likely decrease speed.}

\item{\ldots}{Ignored.}
}
\value{
Returns a \pkg{data.table} with columns of positive and 
negative terms.  In addition, the attributes \code{$counts} and \code{$elements}
return an aggregated count of the usage of the words and a detailed sentiment
score of each word use.  See the examples for more.
}
\description{
Extract the sentiment words from a text.
}
\examples{
library(data.table)
set.seed(10)
x <- get_sentences(sample(hu_liu_cannon_reviews[[2]], 1000, TRUE))
sentiment(x)

pol_words <- extract_sentiment_terms(x)
pol_words
pol_words$sentence
pol_words$neutral
data.table::as.data.table(pol_words)

attributes(extract_sentiment_terms(x))$counts
attributes(extract_sentiment_terms(x))$elements

\dontrun{
library(wordcloud)
library(data.table)

set.seed(10)
x <- get_sentences(sample(hu_liu_cannon_reviews[[2]], 1000, TRUE))
sentiment_words <- extract_sentiment_terms(x)

sentiment_counts <- attributes(sentiment_words)$counts
sentiment_counts[polarity > 0,]

par(mfrow = c(1, 3), mar = c(0, 0, 0, 0))
## Positive Words
with(
    sentiment_counts[polarity > 0,],
    wordcloud(words = words, freq = n, min.freq = 1,
          max.words = 200, random.order = FALSE, rot.per = 0.35,
          colors = brewer.pal(8, "Dark2"), scale = c(4.5, .75)
    )
)
mtext("Positive Words", side = 3, padj = 5)

## Negative Words
with(
    sentiment_counts[polarity < 0,],
    wordcloud(words = words, freq = n, min.freq = 1,
          max.words = 200, random.order = FALSE, rot.per = 0.35,
          colors = brewer.pal(8, "Dark2"), scale = c(4.5, 1)
    )
)
mtext("Negative Words", side = 3, padj = 5)

sentiment_counts[, 
    color := ifelse(polarity > 0, 'red', 
        ifelse(polarity < 0, 'blue', 'gray70')
    )]

## Positive & Negative Together
with(
    sentiment_counts[polarity != 0,],
    wordcloud(words = words, freq = n, min.freq = 1,
          max.words = 200, random.order = FALSE, rot.per = 0.35,
          colors = color, ordered.colors = TRUE, scale = c(5, .75)
    )
)
mtext("Positive (red) & Negative (blue) Words", side = 3, padj = 5)
}
}
