% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_emotion_terms.R
\name{extract_emotion_terms}
\alias{extract_emotion_terms}
\title{Extract Emotion Words}
\usage{
extract_emotion_terms(
  text.var,
  emotion_dt = lexicon::hash_nrc_emotions,
  un.as.negation = TRUE,
  retention_regex = "[^[:alpha:];:,']",
  ...
)
}
\arguments{
\item{text.var}{The text variable.  Can be a \code{get_sentences} object or
a raw character vector though \code{get_sentences} is preferred as it avoids
the repeated cost of doing sentence boundary disambiguation every time
\code{emotion} is run.}

\item{emotion_dt}{A \pkg{data.table} with a \code{token} and \code{emotion}
column (\code{tokens} are nested within the \code{emotion}s.  The table
cannot contain any duplicate rows and must have the \code{token} column set
as the key column (see \code{?data.table::setkey}).  The default emotion
table is \code{lexicon::hash_nrc_emotions}.}

\item{un.as.negation}{logical.  If \code{TRUE} then emotion words prefixed
with an 'un-' are treated as a negation.  For example,\code{"unhappy"} would 
be treated as \code{"not happy"}.  If an emotion word has an un- version in the
\code{emotion_dt} then no substitution is performed and an optional warning
will be given.}

\item{retention_regex}{A regex of what characters to keep.  All other 
characters will be removed.  Note that when this is used all text is lower 
case format.  Only adjust this parameter if you really understand how it is 
used.  Note that swapping the \code{\\\\{p}} for \code{[^[:alpha:];:,\']} may 
retain more alpha letters but will likely decrease speed.}

\item{\ldots}{Ignored.}
}
\value{
Returns a \pkg{data.table} with a columns of emotion terms.
}
\description{
Extract the emotion words from a text.
}
\examples{
\dontrun{
mytext <- c(
    "I am not afraid of you",
    NA,
    "",
    "I love it [not really]", 
    "I'm not angry with you", 
    "I hate it when you lie to me.  It's so humiliating",
    "I'm not happpy anymore.  It's time to end it",
    "She's a darn good friend to me",
    "I went to the terrible store",
    "There is hate and love in each of us",
    "I'm no longer angry!  I'm really experiencing peace but not true joy.",
    
    paste("Out of the night that covers me, Black as the Pit from pole to", 
      "pole, I thank whatever gods may be For my unconquerable soul.",
      "In the fell clutch of circumstance I have not winced nor cried",
      "aloud. Under the bludgeonings of chance My head is bloody, but unbowed.",
      "Beyond this place of wrath and tears Looms but the Horror of the", 
      "shade, And yet the menace of the years Finds, and shall find, me unafraid.",
      "It matters not how strait the gate, How charged with punishments", 
      "the scroll, I am the master of my fate: I am the captain of my soul."
    )    
    
)

mytext2 <- get_sentences(mytext)
emotion(mytext2)

emo_words <- extract_emotion_terms(mytext2)
emo_words
emo_words$sentence
emo_words[, c('anger', 'anticipation', 'disgust', 'fear', 'joy', 'sadness', 'surprise', 'trust')]

attributes(emo_words)$counts
attributes(emo_words)$elements

## directly ona  character string (not recommended: use `get_sentences` first)
extract_emotion_terms(mytext)

brady <- get_sentences(crowdflower_deflategate)
brady_emo <- extract_emotion_terms(brady)

brady_emo
attributes(brady_emo)$counts
attributes(brady_emo)$elements
}
}
