% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.timeseries}
\alias{plot.timeseries}
\title{Plot method for the "timeseries" object.}
\usage{
\method{plot}{timeseries}(x, plot = c("total", "timeseries"), xaxis,
  ylabh = TRUE, ...)
}
\arguments{
\item{x}{a time-series object as returned by
\code{\link{processTimeseries}}}

\item{plot}{a string vector indicating the values to be plotted;
"total": plot of the total signal, summed over
the time-points, and indicating the applied threshold \code{low.thresh};
note that the total levels may have been transformed (e.g. by
\code{\link{log_1}} or \code{\link{ash}}) depending on the arguments
\code{trafo} and \code{dc.trafo} in \code{\link{processTimeseries}};
"timeseries": plot the complete time-series as a heatmap, where time is
plotted bottom-up on the y-axis and segmentation coordinates on the x-axis;}

\item{xaxis}{x-values to use as x-axis (e.g. to reflect absolute
chromosomal coordinates)}

\item{ylabh}{plot y-axis title horizontally}

\item{...}{additional arguments to plot of total signal}
}
\description{
plot the processed time-series object returned from
\code{\link{processTimeseries}}.
}
