% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_covariates.R
\name{spatial_angle}
\alias{spatial_angle}
\title{Calculate spatial angle along a path}
\usage{
spatial_angle(x, coord.names = c("x", "y"), radius = NULL)
}
\arguments{
\item{x}{data.frame with locations}

\item{coord.names}{names of coordinates column in \code{x}}

\item{radius}{for angle calculation. Default is median of step length.}
}
\value{
vector of spatial angle.
}
\description{
\code{spatial_angle} calculate spatial angle between locations, taking a
dataframe as input. Spatial angle is considered as the angle between the
focus point, the first location entering a given circle and the last location
inside.
}
\examples{
\dontrun{
data(simulmode)
spatial_angle(simulmode)
}
}
\author{
Remi Patin, Simon Benhamou.
}
